SET NOCOUNT ON
GO

--
-- Definition for table SYS_VERSION : 
--

CREATE TABLE [dbo].[SYS_VERSION] (
  [syvs_nr_1] int NULL,
  [syvs_nr_2] int NULL,
  [syvs_nr_3] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_PRINTERI : 
--

CREATE TABLE [dbo].[SYS_PRINTERI] (
  [sypr_id_pk] int NULL,
  [sypr_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [sypr_N] int NULL,
  [sypr_B1] int NULL,
  [sypr_B2] int NULL,
  [sypr_cntr_text_normal] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_text_bold_1] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_text_bold_2] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_ladica] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_rezac] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_JMJ : 
--

CREATE TABLE [dbo].[SYS_JMJ] (
  [sy_jmj_name] nvarchar(10) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table START_LOG : 
--

CREATE TABLE [dbo].[START_LOG] (
  [sp_id_pk] int IDENTITY(1, 1) NOT NULL,
  [sp_ks_id_fk] int NULL,
  [sp_nadnevak] datetime NULL,
  [sp_start] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SMJENE : 
--

CREATE TABLE [dbo].[SMJENE] (
  [sm_id_pk] int IDENTITY(1, 1) NOT NULL,
  [sm_name] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sm_start] datetime NULL,
  [sm_end] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table RESERVATION_STAVKE : 
--

CREATE TABLE [dbo].[RESERVATION_STAVKE] (
  [rzs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [rzs_rzz_id_fk] int NOT NULL,
  [rzs_ar_id_fk] int NOT NULL,
  [rzs_cijena] decimal(12, 2) NULL,
  [rzs_kolicina] decimal(12, 3) NULL,
  [rzs_ukupno] decimal(12, 2) NULL,
  [rzs_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table RESERVATION_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[RESERVATION_ZAGLAVLJE] (
  [rzz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [rzz_kn_id_fk] int NULL,
  [rzz_st_id_fk] int NULL,
  [rzz_date] datetime NULL,
  [rzz_date_time] datetime NULL,
  [rzz_date_creation] datetime NULL,
  [rzz_person_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rzz_person_mob] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [rzz_description] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [rzz_ukupno] decimal(12, 2) NULL,
  [rzz_check_in] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table RACUNI_STAVKE : 
--

CREATE TABLE [dbo].[RACUNI_STAVKE] (
  [rs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [rs_racun_id_fk] int NULL,
  [rs_artikal_id_fk] int NULL,
  [rs_gpdv_id_fk] int NULL,
  [rs_gpnp_id_fk] int NULL,
  [rs_popust] decimal(12, 3) NULL,
  [rs_cijena_bez_popusta] decimal(12, 2) NULL,
  [rs_cijena] decimal(12, 2) NULL,
  [rs_kolicina] decimal(12, 2) NULL,
  [rs_pdv] decimal(12, 2) NULL,
  [rs_pnp] decimal(12, 2) NULL,
  [rs_iznos_bez_popusta] decimal(12, 2) NULL,
  [rs_iznos] decimal(12, 2) NULL,
  [rs_narudzba_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PRIMKE_STAVKE : 
--
CREATE TABLE [dbo].[PRIMKE_STAVKE] (
  [ps_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ps_pr_id_fk] int NULL,
  [ps_si_id_fk] int NULL,
  [ps_pdv_id_fk] int NULL,
  [ps_si_povratna_naknada] decimal(8, 2) NULL,
  [ps_si_cijena_osnovna_netto] decimal(12, 4) NULL,
  [ps_si_nabavljena_kolicina] decimal(12, 4) NOT NULL,
  [ps_rabat_postotak] decimal(12, 2) NULL,
  [ps_tot_osnovica] decimal(12, 2) NULL,
  [ps_tot_povratna_naknada] decimal(8, 2) NULL,
  [ps_tot_pdv] decimal(12, 2) NULL,
  [ps_tot_ukupno] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PRIMKE_ZAGLAVLJE : 
--
CREATE TABLE [dbo].[PRIMKE_ZAGLAVLJE] (
  [pr_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pr_sys_broj] int NULL,
  [pr_broj] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [pr_dobavljac_id_fk] int NULL,
  [pr_datum] datetime NULL,
  [pr_datum_knjizenja] datetime NULL,
  [pr_datum_dospijeca] datetime NULL,
  [pr_osnovica] decimal(12, 2) NULL,
  [pr_povratna_naknada] decimal(8, 2) NULL,
  [pr_pdv] decimal(12, 2) NULL,
  [pr_ukupno] decimal(12, 2) NULL,
  [pr_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [pr_proknjizeno] bit NULL,
  [pr_time_created] datetime NULL,
  [pr_status] bit NULL
)
ON [PRIMARY]
GO




--
-- Definition for table PRIMKE_EXTERNAL_STAVKE : 
--
CREATE TABLE [dbo].[PRIMKE_EXTERNAL_STAVKE] (
  [pes_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pes_pez_id_fk] int NULL,
  [pes_si_sifra] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pes_si_barcode] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pes_si_naziv] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pes_si_jmj] nvarchar(10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pes_si_cijena_vpc] decimal(12, 2) NULL,
  [pes_si_pov_nak] decimal(12, 2) NULL,
  [pes_kolicina] decimal(12, 3) NULL,
  [pes_rabat_postotak] decimal(12, 2) NULL,
  [pes_porez_postotak] int NULL,
  [pes_uk_VPC] decimal(12, 2) NULL,
  [pes_uk_PDV] decimal(12, 2) NULL,
  [pes_uk_POV_NAK] decimal(12, 2) NULL,
  [pes_uk_MPC] decimal(12, 2) NULL
)
ON [PRIMARY]
GO



--
-- Definition for table PRIMKE_EXTERNAL_ZAGLAVLJE : 
--
CREATE TABLE [dbo].[PRIMKE_EXTERNAL_ZAGLAVLJE] (
  [pez_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pez_source] nvarchar(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_dob_naziv] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_dob_adresa] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_dob_mjesto] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_dob_oib] nvarchar(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_dob_iban] nvarchar(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_broj] nvarchar(30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_datum] datetime NULL,
  [pez_datum_dospijeca] datetime NULL,
  [pez_datum_knjizenja] datetime NULL,
  [pez_datum_isporuke] datetime NULL,
  [pez_uk_VPC] decimal(12, 2) NULL,
  [pez_uk_PDV] decimal(12, 2) NULL,
  [pez_uk_POV_NAK] decimal(12, 2) NULL,
  [pez_uk_MPC] decimal(12, 2) NULL,
  [pez_note_1] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_note_2] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_note_3] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_note_4] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_status] nvarchar(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [pez_napomena] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
ON [PRIMARY]
GO




--
-- Definition for table PONUDA_STAVKE : 
--
CREATE TABLE [dbo].[PONUDA_STAVKE] (
  [pns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pns_ponuda_id_fk] int NULL,
  [pns_artikal_id_fk] int NULL,
  [pns_gpdv_id_fk] int NULL,
  [pns_gpnp_id_fk] int NULL,
  [pns_popust] decimal(12, 3) NULL,
  [pns_cijena_bez_popusta] decimal(12, 2) NULL,
  [pns_cijena] decimal(12, 2) NULL,
  [pns_kolicina] decimal(12, 2) NULL,
  [pns_pdv] decimal(12, 2) NULL,
  [pns_pnp] decimal(12, 2) NULL,
  [pns_iznos_bez_popusta] decimal(12, 2) NULL,
  [pns_iznos] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PONUDA_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[PONUDA_ZAGLAVLJE] (
  [pnz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pnz_broj] int NULL,
  [pnz_nadnevak] datetime NULL,
  [pnz_kn_id_fk] int NULL,
  [pnz_tv_id_fk] int NULL,
  [pnz_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table OTVORENI_RACUNI_STAVKE : 
--

CREATE TABLE [dbo].[OTVORENI_RACUNI_STAVKE] (
  [wkss_id_pk] int IDENTITY(1, 1) NOT NULL,
  [wkss_wks_id_fk] int NULL,
  [wkss_artikal_id_fk] int NULL,
  [wkss_pdv_id_fk] int NULL,
  [wkss_pnp_id_fk] int NULL,
  [wkss_kolicina] decimal(12, 2) NULL,
  [wkss_popust] decimal(12, 3) NULL,
  [wkss_cijena_bez_popusta] decimal(12, 2) NULL,
  [wkss_cijena] decimal(12, 2) NULL,
  [wkss_pdv] decimal(12, 2) NULL,
  [wkss_pnp] decimal(12, 2) NULL,
  [wkss_iznos_bez_popusta] decimal(12, 2) NULL,
  [wkss_iznos] decimal(12, 2) NULL,
  [wkss_nar_naruceno] bit NULL,
  [wkss_nar_ns_id_pk] int NULL,
  [wkss_nar_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_status] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_vrijeme_izdavanja] datetime NULL,
  [wkss_nar_vrijeme_prihvacanja] datetime NULL,
  [wkss_nar_vrijeme_spremnosti] datetime NULL,
  [wkss_nar_vrijeme_dostave] datetime NULL,
  [wkss_nar_slijed_name] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_slijed_oznaka] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_slijed_priority] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table OTVORENI_RACUNI_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[OTVORENI_RACUNI_ZAGLAVLJE] (
  [wks_id_pk] int IDENTITY(1, 1) NOT NULL,
  [wks_konobar_id_fk] int NULL,
  [wks_stol_id_fk] int NULL,
  [wks_vrijeme] datetime NULL,
  [wks_napomena] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [wks_is_used] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table OTPISI_STAVKE : 
--

CREATE TABLE [dbo].[OTPISI_STAVKE] (
  [os_id_pk] int IDENTITY(1, 1) NOT NULL,
  [os_ot_id_fk] int NULL,
  [os_si_id_fk] int NULL,
  [os_pdv_id_fk] int NULL,
  [os_si_cijena] decimal(12, 2) NULL,
  [os_si_kolicina] decimal(12, 4) NOT NULL,
  [os_tot_osnovica] decimal(12, 2) NULL,
  [os_tot_pov_nak] decimal(10, 2) NULL,
  [os_tot_pdv] decimal(12, 2) NULL,
  [os_tot_ukupno] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table OTPISI_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[OTPISI_ZAGLAVLJE] (
  [ot_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ot_broj] int NULL,
  [ot_datum] datetime NULL,
  [ot_dopusteni] bit NULL,
  [ot_opis] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ot_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ot_proknjizeno] bit NULL,
  [ot_time_created] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NORMATIVI : 
--

CREATE TABLE [dbo].[NORMATIVI] (
  [no_id_pk] int IDENTITY(1, 1) NOT NULL,
  [no_article_id_fk] int NOT NULL,
  [no_sirovina_id_fk] int NOT NULL,
  [no_kolicina] decimal(10, 4) NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBE_STAVKE : 
--

CREATE TABLE [dbo].[NARUDZBE_STAVKE] (
  [ns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ns_nz_id_fk] int NULL,
  [ns_ar_id_fk] int NULL,
  [ns_mi_id_fk] int NULL,
  [ns_vrijeme_izdavanja] datetime NULL,
  [ns_vrijeme_prihvacanja] datetime NULL,
  [ns_vrijeme_spremnosti] datetime NULL,
  [ns_vrijeme_dostave] datetime NULL,
  [ns_ar_cijena] decimal(12, 2) NULL,
  [ns_popust] decimal(12, 2) NULL,
  [ns_kolicina] decimal(12, 4) NULL,
  [ns_iznos_bez_popusta] decimal(12, 2) NULL,
  [ns_iznos] decimal(12, 2) NULL,
  [ns_slijed] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [ns_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ns_status] nvarchar(15) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBE_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[NARUDZBE_ZAGLAVLJE] (
  [nz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [nz_kasa_id_fk] int NULL,
  [nz_konobar_id_fk] int NULL,
  [nz_stol_id_fk] int NULL,
  [nz_vrijeme] datetime NULL,
  [nz_dan] datetime NULL,
  [nz_broj_dnevni] int NULL,
  [nz_broj_full] int NULL,
  [nz_iznos_bez_popusta] decimal(12, 2) NULL,
  [nz_popust] decimal(12, 2) NULL,
  [nz_iznos] decimal(12, 2) NULL,
  [nz_action_type] nvarchar(15) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBE_SLIJEDOVI : 
--

CREATE TABLE [dbo].[NARUDZBE_SLIJEDOVI] (
  [ns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ns_priority] int NULL,
  [ns_naziv_long] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [ns_naziv_short] nvarchar(1) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBE_NAPOMENE_ARTIKLI : 
--

CREATE TABLE [dbo].[NARUDZBE_NAPOMENE_ARTIKLI] (
  [ar_id_fk] int NOT NULL,
  [nr_id_fk] int NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBE_NAPOMENE : 
--

CREATE TABLE [dbo].[NARUDZBE_NAPOMENE] (
  [nr_id_pk] int IDENTITY(1, 1) NOT NULL,
  [nr_napomena] nvarchar(30) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NABAVNI_NALOG_STAVKE : 
--

CREATE TABLE [dbo].[NABAVNI_NALOG_STAVKE] (
  [nns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [nns_nabavni_nalog_id_fk] int NULL,
  [nns_sirovina_id_fk] int NULL,
  [nns_stanje_skladista] decimal(12, 2) NULL,
  [nns_kolicina] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NABAVNI_NALOG_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE] (
  [nnz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [nnz_broj] int NULL,
  [nnz_nadnevak] datetime NULL,
  [nnz_kn_id_fk] int NULL,
  [nnz_do_id_fk] int NULL,
  [nnz_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table KONZUMACIJA_STAVKE : 
--

CREATE TABLE [dbo].[KONZUMACIJA_STAVKE] (
  [kzs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [kzs_kzz_id_fk] int NULL,
  [kzs_artikal_id_fk] int NULL,
  [kzs_gpdv_id_fk] int NULL,
  [kzs_gpnp_id_fk] int NULL,
  [kzs_kolicina] decimal(12, 2) NULL,
  [kzs_cijena_bez_popusta] decimal(12, 2) NULL,
  [kzs_cijena] decimal(12, 2) NULL,
  [kzs_popust] decimal(12, 2) NULL,
  [kzs_pdv] decimal(12, 2) NULL,
  [kzs_pnp] decimal(12, 2) NULL,
  [kzs_iznos_bez_popusta] decimal(12, 2) NULL,
  [kzs_iznos] decimal(12, 2) NULL,
  [kzs_napomena] nvarchar(30) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table KONZUMACIJA_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE] (
  [kzz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [kzz_racun_id_fk] int NULL,
  [kzz_konobar_id_fk] int NULL,
  [kzz_stol_id_fk] int NULL,
  [kzz_tvrtka_id_fk] int NULL,
  [kzz_narucitelj_id_fk] int NULL,
  [kzz_kasa_id_fk] int NULL,
  [kzz_vrijeme] datetime NULL,
  [kzz_nadnevak] datetime NULL,
  [kzz_broj_dnevni] int NULL,
  [kzz_broj_full] int NULL,
  [kzz_popust] decimal(12, 2) NULL,
  [kzz_iznos_bez_popusta] decimal(12, 2) NULL,
  [kzz_iznos] decimal(12, 2) NULL,
  [kzz_pdv] decimal(12, 2) NULL,
  [kzz_pnp] decimal(12, 2) NULL,
  [kzz_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table RACUNI_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[RACUNI_ZAGLAVLJE] (
  [rz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [rz_broj] int NULL,
  [rz_broj_full] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_vrijeme] datetime NULL,
  [rz_dan] datetime NULL,
  [rz_kasa_id_fk] int NULL,
  [rz_konobar_id_fk] int NULL,
  [rz_stol_id_fk] int NULL,
  [rz_tvrtka_id_fk] int NULL,
  [rz_narucitelj_id_fk] int NULL,
  [rz_placanje_id_fk] int NULL,
  [rz_pl_1_id_fk] int NULL,
  [rz_pl_2_id_fk] int NULL,
  [rz_pl_3_id_fk] int NULL,
  [rz_popust] decimal(12, 2) NULL,
  [rz_pdv] decimal(12, 2) NULL,
  [rz_pnp] decimal(12, 2) NULL,
  [rz_iznos_bez_popusta] decimal(12, 2) NULL,
  [rz_iznos] decimal(12, 2) NULL,
  [rz_pl_1_iznos] decimal(12, 2) NULL,
  [rz_pl_2_iznos] decimal(12, 2) NULL,
  [rz_pl_3_iznos] decimal(12, 2) NULL,
  [rz_napomena] nvarchar(200) COLLATE Croatian_CI_AS NULL,
  [rz_datum_dospijeca] datetime NULL,
  [rz_fis_racun_source_id] int NULL,
  [rz_fis_vrijeme_slanja] datetime NULL,
  [rz_fis_vrijeme_obrade] datetime NULL,
  [rz_fis_uuid] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_zastitni_kod] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [rz_fis_jir] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_paragon_broj] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_ozn_pos_pros] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_ozn_nap_uredaja] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_naknadna_dostava] bit NULL,
  [rz_fis_storno_sign] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [rz_fis_np] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [rz_fis_nap_uuid] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_nap_vrijeme_slanja] datetime NULL,
  [rz_fis_nap_vrijeme_obrade] datetime NULL,
  [rz_fis_nap_iznos] decimal(12, 2) NULL,
  [rz_fis_nap_pl_id_fk] int NULL,
  [rz_fis_nap_np] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [rz_fis_nap_fiskalizirano] bit NULL,
  [rz_fis_nap_naknadna_dostava] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table STOLOVI : 
--

CREATE TABLE [dbo].[STOLOVI] (
  [st_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ts_id_fk] int NULL,
  [st_name] int NOT NULL,
  [st_description] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [st_pos_x] int NULL,
  [st_pos_y] int NULL,
  [st_shape_id] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table TERASE : 
--

CREATE TABLE [dbo].[TERASE] (
  [ts_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ts_name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ts_active] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NACINI_PLACANJA : 
--

CREATE TABLE [dbo].[NACINI_PLACANJA] (
  [np_id_pk] int IDENTITY(1, 1) NOT NULL,
  [np_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [np_category_fk] int NOT NULL,
  [np_kar_provizija] decimal(6, 2) NULL,
  [np_sort] int NULL,
  [np_index] int NULL,
  [np_active] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_PLACANJA : 
--

CREATE TABLE [dbo].[SYS_PLACANJA] (
  [sypl_id_pk] int NOT NULL,
  [sypl_name_short] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [sypl_name_long] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [sypl_sort] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUCITELJI : 
--

CREATE TABLE [dbo].[NARUCITELJI] (
  [na_id_pk] int IDENTITY(1, 1) NOT NULL,
  [na_tvrtka_fk] int NULL,
  [na_ime] nvarchar(25) COLLATE Croatian_CI_AS NOT NULL,
  [na_kartica] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [na_kucna_adresa] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [na_mjesto] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [na_oib] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_djelatno_mjesto] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [na_tel_u_tvrtci] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_tel] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_mob] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_biljeska] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [na_popust] decimal(5, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table TVRTKE : 
--

CREATE TABLE [dbo].[TVRTKE] (
  [tv_id_pk] int IDENTITY(1, 1) NOT NULL,
  [tv_sifra] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [tv_ime] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [tv_adresa] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_adresa_broj] nvarchar(10) COLLATE Croatian_CI_AS NULL,
  [tv_mjesto] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_mjesto_postanski_broj] int NULL,
  [tv_state] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_maticni_broj] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [tv_oib] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [tv_porezni_broj] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_iban] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [tv_tel] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [tv_email] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_kontakt_osoba] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [tv_odgoda_placanja] int NULL,
  [tv_stop_tvrtka] bit NULL,
  [tv_note] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [tv_time_inserted] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table KONOBARI : 
--

CREATE TABLE [dbo].[KONOBARI] (
  [kn_id_pk] int IDENTITY(1, 1) NOT NULL,
  [kn_oznaka] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [kn_sifra] nvarchar(10) COLLATE Croatian_CI_AS NOT NULL,
  [kn_barcode] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [kn_name] nvarchar(30) COLLATE Croatian_CI_AS NOT NULL,
  [kn_adresa] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [kn_mjesto] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [kn_oib] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [kn_tel] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [kn_mob] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [kn_note] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [kn_status] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [kn_work_start] datetime NULL,
  [kn_work_end] datetime NULL,
  [kn_active] bit NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table KASE : 
--

CREATE TABLE [dbo].[KASE] (
  [ks_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ks_name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ks_description] nvarchar(50) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table IZDATNICE_STAVKE : 
--

CREATE TABLE [dbo].[IZDATNICE_STAVKE] (
  [is_id_pk] int IDENTITY(1, 1) NOT NULL,
  [is_iz_id_fk] int NOT NULL,
  [is_si_id_fk] int NULL,
  [is_pdv_id_fk] int NULL,
  [is_cijena] decimal(12, 2) NULL,
  [is_kolicina] decimal(12, 4) NOT NULL,
  [is_tot_osnovica] decimal(12, 2) NULL,
  [is_tot_pdv] decimal(12, 2) NULL,
  [is_tot_ukupno] decimal(12, 2) NULL,
  [is_tot_pov_nak] decimal(10, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table IZDATNICE_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[IZDATNICE_ZAGLAVLJE] (
  [iz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [iz_broj] int NULL,
  [iz_mo_id_fk] int NULL,
  [iz_datum] datetime NULL,
  [iz_opis] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [iz_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [iz_proknjizeno] bit NULL,
  [iz_time_created] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table MJESTA_OTPREME : 
--

CREATE TABLE [dbo].[MJESTA_OTPREME] (
  [mo_id_pk] int IDENTITY(1, 1) NOT NULL,
  [mo_oznaka] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [mo_note] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table INVENTURA_STAVKE : 
--

CREATE TABLE [dbo].[INVENTURA_STAVKE] (
  [ins_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ins_in_id_fk] int NULL,
  [ins_sir_id_fk] int NULL,
  [ins_sir_stanje_zateceno] decimal(12, 4) NOT NULL,
  [ins_sir_stanje_kasa] decimal(12, 4) NOT NULL,
  [ins_sir_stanje_razlika] decimal(12, 4) NOT NULL,
  [ins_sir_prosj_nab_cijena] decimal(12, 2) NULL,
  [ins_fin_stanje_zateceno] decimal(8, 2) NULL,
  [ins_fin_stanje_kasa] decimal(8, 2) NULL,
  [ins_fin_stanje_razlika] decimal(8, 2) NULL,
  [ins_pov_nak_razlika] decimal(8, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table INVENTURA_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[INVENTURA_ZAGLAVLJE] (
  [in_id_pk] int IDENTITY(1, 1) NOT NULL,
  [in_broj] int NULL,
  [in_nadnevak] datetime NULL,
  [in_knjizenje] bit NULL,
  [in_napomena] nvarchar(70) COLLATE Croatian_CI_AS NULL,
  [in_proknjizeno] bit NULL
)
ON [PRIMARY]
GO



--
-- Definition for table SIROVINE : 
--

CREATE TABLE [dbo].[SIROVINE] (
  [si_id_pk] int IDENTITY(1, 1) NOT NULL,
  [si_type] int NULL,
  [si_sifra] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [si_ime] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [si_jmj] nvarchar(5) COLLATE Croatian_CI_AS NULL,
  [si_pdv_id_fk] int NULL,
  [si_grupa_fk] int NULL,
  [si_kategorija_fk] int NULL,
  [si_povratna_naknada] decimal(8, 2) NULL,
  [si_kalo] decimal(4, 2) NULL,
  [si_min_kolicina] decimal(10, 2) NULL,
  [si_active] bit NULL,
  [si_time_inserted] datetime NULL
)
ON [PRIMARY]
GO



--
-- Definition for table SIROVINE_EXTERANAL : 
--
CREATE TABLE [dbo].[SIROVINE_EXTERANAL] (
  [sxt_id_pk] int IDENTITY(1, 1) NOT NULL,
  [sxt_sir_id_fk] int NULL,
  [sxt_type_id] int NULL,
  [sxt_sifra] nvarchar(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sxt_barcode_ean] nvarchar(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sxt_naziv] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sxt_jmj] nvarchar(10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sxt_jmj_paket_kol] decimal(12, 2) NULL,
  [sxt_grupa] nvarchar(30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sxt_napomena] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
ON [PRIMARY]
GO




--
-- Definition for table GRUPE_TOUCH_SCREEN_ARTIKLI : 
--

CREATE TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI] (
  [ar_id_fk] int NOT NULL,
  [gt_id_fk] int NOT NULL,
  [gt_ar_order] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_TOUCH_SCREEN : 
--

CREATE TABLE [dbo].[GRUPE_TOUCH_SCREEN] (
  [gt_id_pk] int IDENTITY(1, 1) NOT NULL,
  [gt_name] nvarchar(30) COLLATE Croatian_CI_AS NOT NULL,
  [gt_active] bit NOT NULL,
  [gt_order_index] int NULL,
  [gt_color_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_SIROVINA : 
--

CREATE TABLE [dbo].[GRUPE_SIROVINA] (
  [gs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [gs_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [gs_sysk_id_fk] int NULL,
  [gs_order_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_SIROVINE_KATEGORIJE : 
--

CREATE TABLE [dbo].[SYS_SIROVINE_KATEGORIJE] (
  [sysk_id_pk] int NOT NULL,
  [sysk_name] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table EXTERNAL_DATABASES : 
--

CREATE TABLE [dbo].[EXTERNAL_DATABASES] (
  [ext_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ext_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ext_description] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [ext_db_host] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ext_db_name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_db_user] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_db_password] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table DOBAVLJACI : 
--

CREATE TABLE [dbo].[DOBAVLJACI] (
  [do_id_pk] int IDENTITY(1, 1) NOT NULL,
  [do_sifra] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_name] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [do_adresa] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [do_mjesto] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [do_state] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [do_maticni_broj] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_oib] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_porezni_broj] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [do_ziro_racun] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_tel] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [do_fax] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [do_kontakt_osoba] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_kontakt_osoba_mob] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [do_biljeska] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [do_time_inserted] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table DNEVNI_POLOG : 
--

CREATE TABLE [dbo].[DNEVNI_POLOG] (
  [dp_id_pk] int IDENTITY(1, 1) NOT NULL,
  [dp_vrijeme] datetime NULL,
  [dp_iznos] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table ARTIKLI : 
--

GO
CREATE TABLE [dbo].[ARTIKLI] (
  [ar_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ar_type] int NOT NULL,
  [ar_sifra] int NOT NULL,
  [ar_barcode] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [ar_naziv] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [ar_jmj] nvarchar(5) COLLATE Croatian_CI_AS NULL,
  [ar_kategorija_fk] int NOT NULL,
  [ar_grupa_fk] int NULL,
  [ar_pdv_fk] int NOT NULL,
  [ar_pnp_fk] int NULL,
  [ar_mjesto_izdavanja_fk] int NULL,
  [ar_grupa_pica_fk] int NULL,
  [ar_cijena] decimal(10, 2) NOT NULL,
  [ar_cijena_popust] decimal(10, 2) NULL,
  [ar_cijena_popust_2] decimal(12, 2) NULL,
  [ar_cijena_popust_3] decimal(12, 2) NULL,
  [ar_description] nvarchar(300) COLLATE Croatian_CI_AS NULL,
  [ar_color_index] int NULL,
  [ar_size_index] int NULL,
  [ar_index] int NULL,
  [ar_is_active] bit NULL,
  [ar_time_inserted] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table MJESTA_IZDAVANJA : 
--

CREATE TABLE [dbo].[MJESTA_IZDAVANJA] (
  [mi_id_pk] int IDENTITY(1, 1) NOT NULL,
  [mi_oznaka] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [mi_note] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [mi_vezano] bit NULL,
  [mi_vezano_ispis] bit NULL,
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_PNP : 
--

CREATE TABLE [dbo].[GRUPE_PNP] (
  [gpnp_id_pk] int IDENTITY(1, 1) NOT NULL,
  [gpnp_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [gpnp_postotak] decimal(6, 2) NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_PDV : 
--

CREATE TABLE [dbo].[GRUPE_PDV] (
  [gpdv_id_pk] int IDENTITY(1, 1) NOT NULL,
  [gpdv_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [gpdv_postotak] decimal(6, 2) NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_ARTIKALA : 
--

CREATE TABLE [dbo].[GRUPE_ARTIKALA] (
  [ga_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ga_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [ga_syak_id_fk] int NULL,
  [ga_order_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_ARTIKLI_KATEGORIJE : 
--

CREATE TABLE [dbo].[SYS_ARTIKLI_KATEGORIJE] (
  [syak_id_pk] int NOT NULL,
  [syak_name] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_PICE_KATEGORIJE : 
--

CREATE TABLE [dbo].[SYS_PICE_KATEGORIJE] (
  [sypk_id_pk] int IDENTITY(1, 1) NOT NULL,
  [sypk_name] nvarchar(30) COLLATE Croatian_CI_AS NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table ADMINISTRATORS : 
--

CREATE TABLE [dbo].[ADMINISTRATORS] (
  [adm_id_pk] int IDENTITY(1, 1) NOT NULL,
  [adm_name] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [adm_password] int NULL,
  [adm_rf_id] nvarchar(25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table ACTIVITY_LOG : 
--

CREATE TABLE [dbo].[ACTIVITY_LOG] (
  [ac_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ac_korisnik] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ac_time] datetime NULL,
  [ac_action] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ac_description] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO


--
-- Definition for table x_cust_KART_PLACANJE_M2PAY : 
--

CREATE TABLE [dbo].[x_cust_KART_PLACANJE_M2PAY] (
    [m2pay_id_pk] int IDENTITY(1, 1) NOT NULL,
    [m2pay_rz_id_fk] int NULL,
    [m2pay_vrijeme] datetime NULL,
    [m2pay_Var_transactionResultId] nvarchar(30) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_RESULT_transactionID] nvarchar(40) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_RESULT_FinStatus] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_merchantName] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_merchantAddress] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Time] datetime NULL,
    [m2pay_Var_PRINT_STATUS] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Transaction_Type] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Iznos] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_Tip] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_Ukupno] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_ID_Terminala] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_Trgovca] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_KARTICA_Name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_KARTICA_ID] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Nacin_Unosa] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Provjere] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Vrsta_Kartice] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Broj_Odobrenja] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_GUID] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_GUID_STORNO_PRODAJE] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_RRN] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_AID] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_TVR] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_IAD] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_TSI] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ARC] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO









--
-- Definition for indices : 
--

ALTER TABLE [dbo].[ACTIVITY_LOG]
ADD CONSTRAINT [PK_ACTIVITY_LOG] 
PRIMARY KEY CLUSTERED ([ac_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[ADMINISTRATORS]
ADD CONSTRAINT [PK_SYS_ADMINISTRATOR] 
PRIMARY KEY CLUSTERED ([adm_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ADMINISTRATORS]
ADD CONSTRAINT [UQ_SYS_ADMINISTRATOR_adm_name] 
UNIQUE NONCLUSTERED ([adm_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ADMINISTRATORS]
ADD CONSTRAINT [UQ_SYS_ADMINISTRATOR_adm_password] 
UNIQUE NONCLUSTERED ([adm_password])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SYS_PICE_KATEGORIJE]
ADD CONSTRAINT [PK_SYS_PICE_KATEGORIJE] 
PRIMARY KEY CLUSTERED ([sypk_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SYS_ARTIKLI_KATEGORIJE]
ADD CONSTRAINT [PK_SYS_ARTIKLI_KATEGORIJE] 
PRIMARY KEY CLUSTERED ([syak_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[GRUPE_ARTIKALA]
ADD CONSTRAINT [PK_GRUPE_ARTIKALA] 
PRIMARY KEY CLUSTERED ([ga_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_ARTIKALA]
ADD CONSTRAINT [UQ_GRUPE_ARTIKALA_name] 
UNIQUE NONCLUSTERED ([ga_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[GRUPE_PDV]
ADD CONSTRAINT [PK_GRUPE_PDV] 
PRIMARY KEY CLUSTERED ([gpdv_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_PDV]
ADD CONSTRAINT [UQ_GRUPE_PDV_name] 
UNIQUE NONCLUSTERED ([gpdv_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[GRUPE_PNP]
ADD CONSTRAINT [PK_GRUPE_PNP] 
PRIMARY KEY CLUSTERED ([gpnp_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_PNP]
ADD CONSTRAINT [UQ_GRUPE_PNP_name] 
UNIQUE NONCLUSTERED ([gpnp_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[MJESTA_IZDAVANJA]
ADD CONSTRAINT [PK_MJESTA_IZDAVANJA] 
PRIMARY KEY CLUSTERED ([mi_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[MJESTA_IZDAVANJA]
ADD CONSTRAINT [UQ_MJESTA_IZDAVANJA_oznaka] 
UNIQUE NONCLUSTERED ([mi_oznaka])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [PK_ARTIKLI] 
PRIMARY KEY CLUSTERED ([ar_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [UQ_ARTIKLI_ar_naziv] 
UNIQUE NONCLUSTERED ([ar_naziv])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [UQ_ARTIKLI_ar_sifra] 
UNIQUE NONCLUSTERED ([ar_sifra])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[DNEVNI_POLOG]
ADD CONSTRAINT [PK_DNEVNI_POLOG] 
PRIMARY KEY CLUSTERED ([dp_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[DOBAVLJACI]
ADD CONSTRAINT [PK_DOBAVLJACI] 
PRIMARY KEY CLUSTERED ([do_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DOBAVLJACI]
ADD CONSTRAINT [UQ_DOBAVLJACI_do_name] 
UNIQUE NONCLUSTERED ([do_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[EXTERNAL_DATABASES]
ADD CONSTRAINT [PK_EXTERNAL_DATABASES] 
PRIMARY KEY CLUSTERED ([ext_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SYS_SIROVINE_KATEGORIJE]
ADD CONSTRAINT [PK_SYS_SIROVINE_KATEGORIJE] 
PRIMARY KEY CLUSTERED ([sysk_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[GRUPE_SIROVINA]
ADD CONSTRAINT [PK_GRUPE_SIROVINA] 
PRIMARY KEY CLUSTERED ([gs_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_SIROVINA]
ADD CONSTRAINT [UQ_GRUPE_SIROVINA_name] 
UNIQUE NONCLUSTERED ([gs_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN]
ADD CONSTRAINT [PK_GRUPE_TOUCH_SCREEN] 
PRIMARY KEY CLUSTERED ([gt_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN]
ADD CONSTRAINT [UQ_GRUPE_TOUCH_SCREEN_gt_name] 
UNIQUE NONCLUSTERED ([gt_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI]
ADD CONSTRAINT [PK_GRUPE_TOUCH_SCREEN_ARTIKLI] 
PRIMARY KEY CLUSTERED ([ar_id_fk], [gt_id_fk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SIROVINE]
ADD CONSTRAINT [PK_SIROVINE] 
PRIMARY KEY CLUSTERED ([si_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[SIROVINE]
ADD CONSTRAINT [UQ_SIROVINE_si_ime] 
UNIQUE NONCLUSTERED ([si_ime])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[SIROVINE]
ADD CONSTRAINT [UQ_SIROVINE_si_sifra] 
UNIQUE NONCLUSTERED ([si_sifra])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO




ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE]
ADD CONSTRAINT [PK_INVENTURA_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([in_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [PK_INVENTURA_STAVKE] 
PRIMARY KEY CLUSTERED ([ins_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[MJESTA_OTPREME]
ADD CONSTRAINT [PK_MJESTA_OTPREME] 
PRIMARY KEY CLUSTERED ([mo_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[MJESTA_OTPREME]
ADD CONSTRAINT [UQ_MJESTA_OTPREME_oznaka] 
UNIQUE NONCLUSTERED ([mo_oznaka])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[IZDATNICE_ZAGLAVLJE]
ADD CONSTRAINT [PK_IZDATNICE_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([iz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [PK_IZDATNICE_STAVKE] 
PRIMARY KEY CLUSTERED ([is_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[KASE]
ADD CONSTRAINT [PK_KASE] 
PRIMARY KEY CLUSTERED ([ks_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[KASE]
ADD CONSTRAINT [UQ_KASE_ks_name] 
UNIQUE NONCLUSTERED ([ks_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[KONOBARI]
ADD CONSTRAINT [PK_KONOBARI] 
PRIMARY KEY CLUSTERED ([kn_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[KONOBARI]
ADD CONSTRAINT [UQ_KONOBARI_kn_name] 
UNIQUE NONCLUSTERED ([kn_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[KONOBARI]
ADD CONSTRAINT [UQ_KONOBARI_kn_oznaka] 
UNIQUE NONCLUSTERED ([kn_oznaka])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[KONOBARI]
ADD CONSTRAINT [UQ_KONOBARI_kn_sifra] 
UNIQUE NONCLUSTERED ([kn_sifra])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[TVRTKE]
ADD CONSTRAINT [PK_TVRTKE] 
PRIMARY KEY CLUSTERED ([tv_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[TVRTKE]
ADD CONSTRAINT [UQ_TVRTKE_tv_ime] 
UNIQUE NONCLUSTERED ([tv_ime])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NARUCITELJI]
ADD CONSTRAINT [PK_NARUCITELJI] 
PRIMARY KEY CLUSTERED ([na_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUCITELJI]
ADD CONSTRAINT [UQ_NARUCITELJI_na_ime] 
UNIQUE NONCLUSTERED ([na_ime])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SYS_PLACANJA]
ADD CONSTRAINT [PK_SYS_PLACANJA] 
PRIMARY KEY CLUSTERED ([sypl_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NACINI_PLACANJA]
ADD CONSTRAINT [PK_NACINI_PLACANJA] 
PRIMARY KEY CLUSTERED ([np_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NACINI_PLACANJA]
ADD CONSTRAINT [UQ_NACINI_PLACANJA_name] 
UNIQUE NONCLUSTERED ([np_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[TERASE]
ADD CONSTRAINT [PK_TERASE] 
PRIMARY KEY CLUSTERED ([ts_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[TERASE]
ADD CONSTRAINT [UQ_TERASE_ts_name] 
UNIQUE NONCLUSTERED ([ts_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[STOLOVI]
ADD CONSTRAINT [PK_STOLOVI] 
PRIMARY KEY CLUSTERED ([st_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[STOLOVI]
ADD CONSTRAINT [UQ_STOLOVI_st_name] 
UNIQUE NONCLUSTERED ([st_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [PK_RACUNI_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([rz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [PK_KONZUMACIJA_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([kzz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[KONZUMACIJA_STAVKE]
ADD CONSTRAINT [PK_KONZUMACIJA_STAVKE] 
PRIMARY KEY CLUSTERED ([kzs_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE]
ADD CONSTRAINT [PK_NABAVNI_NALOG_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([nnz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE]
ADD CONSTRAINT [PK_NABAVNI_NALOG_STAVKE] 
PRIMARY KEY CLUSTERED ([nns_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NARUDZBE_NAPOMENE]
ADD CONSTRAINT [PK_NARUDZBE_NAPOMENE] 
PRIMARY KEY CLUSTERED ([nr_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUDZBE_NAPOMENE]
ADD CONSTRAINT [UQ_NARUDZBE_NAPOMENE_nr_napomena] 
UNIQUE NONCLUSTERED ([nr_napomena])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NARUDZBE_SLIJEDOVI]
ADD CONSTRAINT [PK_NARUDZBE_SLIJEDOVI] 
PRIMARY KEY CLUSTERED ([ns_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUDZBE_SLIJEDOVI]
ADD CONSTRAINT [UQ_NARUDZBE_SLIJEDOVI_ns_naziv_long] 
UNIQUE NONCLUSTERED ([ns_naziv_long])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUDZBE_SLIJEDOVI]
ADD CONSTRAINT [UQ_NARUDZBE_SLIJEDOVI_ns_naziv_short] 
UNIQUE NONCLUSTERED ([ns_naziv_short])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE]
ADD CONSTRAINT [PK_NARUDZBE_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([nz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NARUDZBE_STAVKE]
ADD CONSTRAINT [PK_NARUDZBE_STAVKE] 
PRIMARY KEY CLUSTERED ([ns_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[NORMATIVI]
ADD CONSTRAINT [PK_NORMATIVI] 
PRIMARY KEY CLUSTERED ([no_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[OTPISI_ZAGLAVLJE]
ADD CONSTRAINT [PK_OTPISI] 
PRIMARY KEY CLUSTERED ([ot_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[OTPISI_STAVKE]
ADD CONSTRAINT [PK_OTPISI_STAVKE] 
PRIMARY KEY CLUSTERED ([os_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[OTVORENI_RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [PK_OTVORENI_RACUNI_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([wks_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE]
ADD CONSTRAINT [PK_OTVORENI_RACUNI_STAVKE] 
PRIMARY KEY CLUSTERED ([wkss_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [PK_PONUDA_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([pnz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [PK_PONUDA_STAVKE] 
PRIMARY KEY CLUSTERED ([pns_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE]
ADD CONSTRAINT [PK_PRIMKE_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([pr_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [PK_PRIMKE_STAVKE] 
PRIMARY KEY CLUSTERED ([ps_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [PK_RACUNI_STAVKE] 
PRIMARY KEY CLUSTERED ([rs_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[RESERVATION_ZAGLAVLJE]
ADD CONSTRAINT [PK_RESERVATION_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([rzz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[RESERVATION_STAVKE]
ADD CONSTRAINT [PK_RESERVATION_STAVKE] 
PRIMARY KEY CLUSTERED ([rzs_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SMJENE]
ADD CONSTRAINT [PK_SMJENE] 
PRIMARY KEY CLUSTERED ([sm_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[START_LOG]
ADD CONSTRAINT [PK_START_LOG] 
PRIMARY KEY CLUSTERED ([sp_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



--
-- Definition for foreign keys : 
--

ALTER TABLE [dbo].[GRUPE_ARTIKALA]
ADD CONSTRAINT [FK_GRUPE_ARTIKALA_SYS_ARTIKLI_KATEGORIJE] FOREIGN KEY ([ga_syak_id_fk]) 
  REFERENCES [dbo].[SYS_ARTIKLI_KATEGORIJE] ([syak_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_ARTIKLI] FOREIGN KEY ([ar_grupa_pica_fk]) 
  REFERENCES [dbo].[SYS_PICE_KATEGORIJE] ([sypk_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_GRUPE_ARTIKALA] FOREIGN KEY ([ar_grupa_fk]) 
  REFERENCES [dbo].[GRUPE_ARTIKALA] ([ga_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_GRUPE_PDV] FOREIGN KEY ([ar_pdv_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_GRUPE_PNP] FOREIGN KEY ([ar_pnp_fk]) 
  REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_MJESTA_IZDAVANJA] FOREIGN KEY ([ar_mjesto_izdavanja_fk]) 
  REFERENCES [dbo].[MJESTA_IZDAVANJA] ([mi_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_SYS_ARTIKLI_KATEGORIJE] FOREIGN KEY ([ar_kategorija_fk]) 
  REFERENCES [dbo].[SYS_ARTIKLI_KATEGORIJE] ([syak_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[GRUPE_SIROVINA]
ADD CONSTRAINT [FK_GRUPE_SIROVINA_SYS_SIROVINE_KATEGORIJE] FOREIGN KEY ([gs_sysk_id_fk]) 
  REFERENCES [dbo].[SYS_SIROVINE_KATEGORIJE] ([sysk_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI]
ADD CONSTRAINT [FK_GRUPE_TOUCH_SCREEN_ARTIKLI_ARTIKLI] FOREIGN KEY ([ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI]
ADD CONSTRAINT [FK_GRUPE_TOUCH_SCREEN_ARTIKLI_GRUPE_TOUCH_SCREEN] FOREIGN KEY ([gt_id_fk]) 
  REFERENCES [dbo].[GRUPE_TOUCH_SCREEN] ([gt_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[SIROVINE]
ADD CONSTRAINT [FK_SIROVINE_GRUPE_SIROVINA] FOREIGN KEY ([si_grupa_fk]) 
  REFERENCES [dbo].[GRUPE_SIROVINA] ([gs_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[SIROVINE]
ADD CONSTRAINT [FK_SIROVINE_SYS_SIROVINE_KATEGORIJE] FOREIGN KEY ([si_kategorija_fk]) 
  REFERENCES [dbo].[SYS_SIROVINE_KATEGORIJE] ([sysk_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO




ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [FK_INVENTURA_STAVKE_INVENTURA_ZAGLAVLJE] FOREIGN KEY ([ins_in_id_fk]) 
  REFERENCES [dbo].[INVENTURA_ZAGLAVLJE] ([in_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [FK_INVENTURA_STAVKE_SIROVINE] FOREIGN KEY ([ins_sir_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[IZDATNICE_ZAGLAVLJE]
ADD CONSTRAINT [FK_IZDATNICE_ZAGLAVLJE_IZDATNICE_ZAGLAVLJE] FOREIGN KEY ([iz_id_pk]) 
  REFERENCES [dbo].[IZDATNICE_ZAGLAVLJE] ([iz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_ZAGLAVLJE]
ADD CONSTRAINT [FK_IZDATNICE_ZAGLAVLJE_MJESTA_OTPREME] FOREIGN KEY ([iz_mo_id_fk]) 
  REFERENCES [dbo].[MJESTA_OTPREME] ([mo_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [FK_IZDATNICE_STAVKE_GRUPE_PDV] FOREIGN KEY ([is_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [FK_IZDATNICE_STAVKE_IZDATNICE_ZAGLAVLJE] FOREIGN KEY ([is_iz_id_fk]) 
  REFERENCES [dbo].[IZDATNICE_ZAGLAVLJE] ([iz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [FK_IZDATNICE_STAVKE_SIROVINE] FOREIGN KEY ([is_si_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[KASE]
ADD CONSTRAINT [FK_KASE_KASE] FOREIGN KEY ([ks_id_pk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NARUCITELJI]
ADD CONSTRAINT [FK_NARUCITELJI_TVRTKE] FOREIGN KEY ([na_tvrtka_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NACINI_PLACANJA]
ADD CONSTRAINT [FK_NACINI_PLACANJA_SYS_PLACANJA] FOREIGN KEY ([np_category_fk]) 
  REFERENCES [dbo].[SYS_PLACANJA] ([sypl_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[STOLOVI]
ADD CONSTRAINT [FK_STOLOVI_TERASE] FOREIGN KEY ([ts_id_fk]) 
  REFERENCES [dbo].[TERASE] ([ts_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_KASE] FOREIGN KEY ([rz_kasa_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([rz_konobar_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA] FOREIGN KEY ([rz_placanje_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA1] FOREIGN KEY ([rz_pl_1_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA2] FOREIGN KEY ([rz_pl_2_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA3] FOREIGN KEY ([rz_pl_3_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([rz_narucitelj_id_fk]) 
  REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([rz_stol_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([rz_tvrtka_id_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_KASA] FOREIGN KEY ([kzz_kasa_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([kzz_konobar_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([kzz_narucitelj_id_fk]) 
  REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_RACUNI_ZAGLAVLJE] FOREIGN KEY ([kzz_racun_id_fk]) 
  REFERENCES [dbo].[RACUNI_ZAGLAVLJE] ([rz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([kzz_stol_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE]
ADD CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([kzz_tvrtka_id_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[KONZUMACIJA_STAVKE]
ADD CONSTRAINT [FK_KONZUMACIJA_STAVKE_ARTIKLI] FOREIGN KEY ([kzs_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_STAVKE]
ADD CONSTRAINT [FK_KONZUMACIJA_STAVKE_KONZUMACIJA_ZAGLAVLJE] FOREIGN KEY ([kzs_kzz_id_fk]) 
  REFERENCES [dbo].[KONZUMACIJA_ZAGLAVLJE] ([kzz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_STAVKE]
ADD CONSTRAINT [FK_KONZUMACIJA_STAVKE_PDV_GRUPA] FOREIGN KEY ([kzs_gpdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KONZUMACIJA_STAVKE]
ADD CONSTRAINT [FK_KONZUMACIJA_STAVKE_PNP_GRUPA] FOREIGN KEY ([kzs_gpnp_id_fk]) 
  REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE]
ADD CONSTRAINT [FK_NABAVNI_NALOG_ZAGLAVLJE_DOBAVLJACI] FOREIGN KEY ([nnz_do_id_fk]) 
  REFERENCES [dbo].[DOBAVLJACI] ([do_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE]
ADD CONSTRAINT [FK_NABAVNI_NALOG_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([nnz_kn_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE]
ADD CONSTRAINT [FK_NABAVNI_NALOG_STAVKE_NABAVNI_NALOG_ZAGLAVLJE] FOREIGN KEY ([nns_nabavni_nalog_id_fk]) 
  REFERENCES [dbo].[NABAVNI_NALOG_ZAGLAVLJE] ([nnz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE]
ADD CONSTRAINT [FK_NABAVNI_NALOG_STAVKE_SIROVINE] FOREIGN KEY ([nns_sirovina_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NARUDZBE_NAPOMENE_ARTIKLI]
ADD CONSTRAINT [FK_NARUDZBE_NAPOMENE_ARTIKLI_ARTIKLI] FOREIGN KEY ([ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBE_NAPOMENE_ARTIKLI]
ADD CONSTRAINT [FK_NARUDZBE_NAPOMENE_ARTIKLI_NARUDZBE_NAPOMENE] FOREIGN KEY ([nr_id_fk]) 
  REFERENCES [dbo].[NARUDZBE_NAPOMENE] ([nr_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE]
ADD CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_KASE] FOREIGN KEY ([nz_kasa_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE]
ADD CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([nz_konobar_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE]
ADD CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([nz_stol_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NARUDZBE_STAVKE]
ADD CONSTRAINT [FK_NARUDZBE_STAVKE_ARTIKLI] FOREIGN KEY ([ns_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBE_STAVKE]
ADD CONSTRAINT [FK_NARUDZBE_STAVKE_MJESTA_IZDAVANJA] FOREIGN KEY ([ns_mi_id_fk]) 
  REFERENCES [dbo].[MJESTA_IZDAVANJA] ([mi_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBE_STAVKE]
ADD CONSTRAINT [FK_NARUDZBE_STAVKE_NARUDZBE_ZAGLAVLJE] FOREIGN KEY ([ns_nz_id_fk]) 
  REFERENCES [dbo].[NARUDZBE_ZAGLAVLJE] ([nz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[NORMATIVI]
ADD CONSTRAINT [FK_NORMATIVI_ARTIKLI] FOREIGN KEY ([no_article_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NORMATIVI]
ADD CONSTRAINT [FK_NORMATIVI_SIROVINE] FOREIGN KEY ([no_sirovina_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[OTPISI_STAVKE]
ADD CONSTRAINT [FK_OTPISI_STAVKE_GRUPE_PDV] FOREIGN KEY ([os_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[OTPISI_STAVKE]
ADD CONSTRAINT [FK_OTPISI_STAVKE_OTPISI_ZAGLAVLJE] FOREIGN KEY ([os_ot_id_fk]) 
  REFERENCES [dbo].[OTPISI_ZAGLAVLJE] ([ot_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[OTPISI_STAVKE]
ADD CONSTRAINT [FK_OTPISI_STAVKE_SIROVINE] FOREIGN KEY ([os_si_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[OTVORENI_RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_OTVORENI_RACUNI_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([wks_konobar_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[OTVORENI_RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_OTVORENI_RACUNI_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([wks_stol_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE]
ADD CONSTRAINT [FK_OTVORENI_RACUNI_STAVKE_ARTIKLI] FOREIGN KEY ([wkss_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE]
ADD CONSTRAINT [FK_OTVORENI_RACUNI_STAVKE_OTVORENI_RACUNI_ZAGLAVLJE] FOREIGN KEY ([wkss_wks_id_fk]) 
  REFERENCES [dbo].[OTVORENI_RACUNI_ZAGLAVLJE] ([wks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [FK_PONUDA_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([pnz_kn_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [FK_PONUDA_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([pnz_tv_id_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_ARTIKLI] FOREIGN KEY ([pns_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PDV] FOREIGN KEY ([pns_gpdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PNP] FOREIGN KEY ([pns_gpnp_id_fk]) 
  REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_PONUDA_ZAGLAVLJE] FOREIGN KEY ([pns_ponuda_id_fk]) 
  REFERENCES [dbo].[PONUDA_ZAGLAVLJE] ([pnz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE]
ADD CONSTRAINT [FK_PRIMKE_ZAGLAVLJE_DOBAVLJACI] FOREIGN KEY ([pr_dobavljac_id_fk]) 
  REFERENCES [dbo].[DOBAVLJACI] ([do_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_GRUPE_PDV] FOREIGN KEY ([ps_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_PRIMKE_ZAGLAVLJE] FOREIGN KEY ([ps_pr_id_fk]) 
  REFERENCES [dbo].[PRIMKE_ZAGLAVLJE] ([pr_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_SIROVINE] FOREIGN KEY ([ps_si_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_ARTIKLI] FOREIGN KEY ([rs_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_GRUPE_PDV] FOREIGN KEY ([rs_gpdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_GRUPE_PNP] FOREIGN KEY ([rs_gpnp_id_fk]) 
  REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO


ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_RACUNI_ZAGLAVLJE] FOREIGN KEY ([rs_racun_id_fk]) 
  REFERENCES [dbo].[RACUNI_ZAGLAVLJE] ([rz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO


ALTER TABLE [dbo].[RESERVATION_ZAGLAVLJE]
ADD CONSTRAINT [FK_RESERVATION_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([rzz_kn_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RESERVATION_ZAGLAVLJE]
ADD CONSTRAINT [FK_RESERVATION_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([rzz_st_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[RESERVATION_STAVKE]
ADD CONSTRAINT [FK_RESERVATION_STAVKE_ARTIKLI] FOREIGN KEY ([rzs_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RESERVATION_STAVKE]
ADD CONSTRAINT [FK_RESERVATION_STAVKE_RESERVATION_ZAGLAVLJE] FOREIGN KEY ([rzs_rzz_id_fk]) 
  REFERENCES [dbo].[RESERVATION_ZAGLAVLJE] ([rzz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



ALTER TABLE [dbo].[START_LOG]
ADD CONSTRAINT [FK_START_LOG_KASE] FOREIGN KEY ([sp_ks_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO


ALTER TABLE [dbo].[PRIMKE_EXTERNAL_ZAGLAVLJE]
ADD CONSTRAINT [PK_PRIMKE_EXTERNAL_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([pez_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[PRIMKE_EXTERNAL_STAVKE]
ADD CONSTRAINT [PK_PRIMKE_EXTERNAL_STAVKE] 
PRIMARY KEY CLUSTERED ([pes_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO



ALTER TABLE [dbo].[SIROVINE_EXTERANAL]
ADD CONSTRAINT [PK_SIROVINE_EXTERANAL] 
PRIMARY KEY CLUSTERED ([sxt_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO
 

ALTER TABLE [dbo].[PRIMKE_EXTERNAL_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_EXTERNAL_STAVKE_PRIMKE_EXTERNAL_ZAGLAVLJE] FOREIGN KEY ([pes_pez_id_fk]) 
  REFERENCES [dbo].[PRIMKE_EXTERNAL_ZAGLAVLJE] ([pez_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO


ALTER TABLE [dbo].[SIROVINE_EXTERANAL]
ADD CONSTRAINT [FK_SIROVINE_EXTERANAL_SIROVINE] FOREIGN KEY ([sxt_sir_id_fk]) 
  REFERENCES [dbo].[SIROVINE] ([si_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



--
-- Definition for indices : 
--





IF (OBJECT_ID('dbo.FK_SIROVINE_GRUPE_PDV', 'F') IS NULL)
	BEGIN
	ALTER TABLE [dbo].[SIROVINE]  WITH CHECK ADD  CONSTRAINT [FK_SIROVINE_GRUPE_PDV] FOREIGN KEY([si_pdv_id_fk])
	REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk])
	ALTER TABLE [dbo].[SIROVINE] CHECK CONSTRAINT [FK_SIROVINE_GRUPE_PDV]
	END
GO


IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'UQ_SIROVINE_EXTERANAL_sxt_sifra')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX UQ_SIROVINE_EXTERANAL_sxt_sifra ON SIROVINE_EXTERANAL(sxt_sifra) WHERE sxt_sifra IS NOT NULL
	END
GO


IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'UQ_SIROVINE_EXTERANAL_sxt_barcode_ean')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX UQ_SIROVINE_EXTERANAL_sxt_barcode_ean ON SIROVINE_EXTERANAL(sxt_barcode_ean) WHERE sxt_barcode_ean IS NOT NULL
	END
GO


IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'UQ_ARTIKLI_ar_barcode')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX UQ_ARTIKLI_ar_barcode ON ARTIKLI(ar_barcode) WHERE ar_barcode IS NOT NULL
	END
GO


IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_owner_bckp' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_owner_bckp];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_certificates_s' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_certificates_s];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_certificates_z' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_certificates_z];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_assembly_files_s' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_assembly_files_s];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_assembly_files_z' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_assembly_files_z];
END
GO


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '_sys_sql_assebmly')
CREATE TABLE [dbo].[_sys_sql_assebmly] (
  [sql_serv] int NULL,
  CONSTRAINT [FK_sys_sql_assebmly] FOREIGN KEY ([sql_serv]) 
  REFERENCES [dbo].[RACUNI_STAVKE] ([rs_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
)
ON [PRIMARY]
GO


GO
Create trigger sys_owner_bckp
	ON RACUNI_STAVKE
after insert
as 
 BEGIN
    --INSERT
    IF NOT EXISTS (SELECT *
                   FROM   deleted)
      BEGIN
        INSERT INTO _sys_sql_assebmly
        SELECT rs_id_pk
        FROM   inserted
      END
 END
GO
Create Trigger sys_certificates_s
     ON RACUNI_STAVKE
INSTEAD OF DELETE 
AS
BEGIN
ROLLBACK;
END
GO
Create Trigger sys_certificates_z
     ON RACUNI_ZAGLAVLJE
INSTEAD OF DELETE 
AS
BEGIN
ROLLBACK;
END
GO
Create Trigger sys_assembly_files_s
     ON RACUNI_STAVKE
INSTEAD OF UPDATE 
AS
BEGIN
ROLLBACK;
END
GO
CREATE TRIGGER sys_assembly_files_z
	ON RACUNI_ZAGLAVLJE
AFTER UPDATE
AS
IF ( UPDATE(rz_pdv) OR UPDATE(rz_pnp) OR UPDATE(rz_iznos_bez_popusta) OR UPDATE(rz_iznos) OR UPDATE(rz_pl_1_iznos) OR UPDATE(rz_pl_2_iznos) OR UPDATE(rz_pl_3_iznos))
BEGIN
    ROLLBACK
    RAISERROR('Sql', 16, 1);
END;
GO


