------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------  UPDATE TO CURRENT VERSION
------------------------------------------------
------------------------------------------------
------------------------------------------------
-- NAPOMENA - CIJELA SKRIPTA BE SMIJE SADRZAVATI ZNAK 'HASH'
-- JER SE ON KORISTI KAO SPLIT KARAKTER PRILIKOM IZVRSAVANJA
-- SKRIPTE U BLUE POS PROGRAMU

GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE_EXTERANAL' AND COLUMN_NAME = 'sxt_type_id')
ALTER TABLE [dbo].[SIROVINE_EXTERANAL] ADD sxt_type_id int NULL
GO


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '_sys_sql_assebmly')
CREATE TABLE [dbo].[_sys_sql_assebmly] (
  [sql_serv] int NULL,
  CONSTRAINT [FK_sys_sql_assebmly] FOREIGN KEY ([sql_serv]) 
  REFERENCES [dbo].[RACUNI_STAVKE] ([rs_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
)
ON [PRIMARY]
GO



------------------------------------------------
--------  DROP TABLES
------------------------------------------------
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_STAVKE')
DROP TABLE [dbo].[PRATECI_DOKUMENTI_STAVKE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_ZAGLAVLJE')
DROP TABLE [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE] 
GO


------------------------------------------------
--------  DROP COLUMNS
------------------------------------------------
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_image')
ALTER TABLE [dbo].[ARTIKLI] DROP COLUMN ar_image
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_icon')
ALTER TABLE [dbo].[ARTIKLI] DROP COLUMN ar_icon
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_prat_dok_id_fk')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_prat_dok_id_fk
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_STAVKE')
DROP TABLE [dbo].[PRATECI_DOKUMENTI_STAVKE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_ZAGLAVLJE')
DROP TABLE [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE] 
GO



------------------------------------------------
--------  ADD TABLES
------------------------------------------------
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'x_cust_KART_PLACANJE_M2PAY')
CREATE TABLE [dbo].[x_cust_KART_PLACANJE_M2PAY] (
    [m2pay_id_pk] int IDENTITY(1, 1) NOT NULL,
    [m2pay_rz_id_fk] int NULL,
    [m2pay_vrijeme] datetime NULL,
    [m2pay_Var_transactionResultId] nvarchar(30) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_RESULT_transactionID] nvarchar(40) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_RESULT_FinStatus] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_merchantName] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_merchantAddress] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Time] datetime NULL,
    [m2pay_Var_PRINT_STATUS] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Transaction_Type] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Iznos] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_Tip] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_Ukupno] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_ID_Terminala] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_Trgovca] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_KARTICA_Name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_KARTICA_ID] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Nacin_Unosa] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Provjere] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Vrsta_Kartice] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Broj_Odobrenja] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_GUID] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_GUID_STORNO_PRODAJE] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_RRN] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_AID] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_TVR] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_IAD] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_TSI] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ARC] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO


------------------------------------------------
--------  ADD COLUMNS
------------------------------------------------
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_type')
ALTER TABLE [dbo].[ARTIKLI] ADD ar_type int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE' AND COLUMN_NAME = 'si_type')
ALTER TABLE [dbo].[SIROVINE] ADD si_type int NULL
GO
UPDATE ARTIKLI SET ARTIKLI.ar_type = 0 WHERE ARTIKLI.ar_type IS NULL
GO
UPDATE SIROVINE SET SIROVINE.si_type = 0 WHERE SIROVINE.si_type IS NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_ARTIKALA' AND COLUMN_NAME = 'ga_order_index')
ALTER TABLE [dbo].[GRUPE_ARTIKALA] ADD ga_order_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_SIROVINA' AND COLUMN_NAME = 'gs_order_index')
ALTER TABLE [dbo].[GRUPE_SIROVINA] ADD gs_order_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUCITELJI' AND COLUMN_NAME = 'na_oib')
ALTER TABLE [dbo].[NARUCITELJI] ADD na_oib nvarchar(15) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NACINI_PLACANJA' AND COLUMN_NAME = 'np_index')
ALTER TABLE [dbo].[NACINI_PLACANJA] ADD np_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NACINI_PLACANJA' AND COLUMN_NAME = 'np_active')
ALTER TABLE [dbo].[NACINI_PLACANJA] ADD np_active bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_uuid')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_uuid nvarchar(50) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_vrijeme_slanja')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_vrijeme_slanja datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_vrijeme_obrade')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_vrijeme_obrade datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_iznos')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_iznos decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_pl_id_fk')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_pl_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_np')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_np nvarchar(1) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_fiskalizirano')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_fiskalizirano bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_fis_nap_naknadna_dostava')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_fis_nap_naknadna_dostava bit NULL
GO
------------------------------------------------
------------------------------------------------
UPDATE NACINI_PLACANJA SET np_sort = np_id_pk WHERE np_sort IS NULL
GO
UPDATE NACINI_PLACANJA SET np_sort = np_id_pk WHERE (np_sort = 0 AND NOT np_name = 'NOVANICE')
GO
UPDATE NACINI_PLACANJA SET np_sort = np_id_pk WHERE (np_sort = 1 AND NOT np_name = 'NOVANICE')
GO
UPDATE NACINI_PLACANJA SET np_sort = 1 WHERE np_name = 'NOVANICE'
GO
UPDATE NACINI_PLACANJA SET np_index = 1 WHERE np_index IS NULL
GO
UPDATE NACINI_PLACANJA SET np_index = 100 WHERE np_id_pk = 10
GO
UPDATE NACINI_PLACANJA set np_active = 1 WHERE np_active IS NULL
GO
UPDATE GRUPE_ARTIKALA SET GRUPE_ARTIKALA.ga_order_index = 1 WHERE GRUPE_ARTIKALA.ga_order_index IS NULL
GO
UPDATE GRUPE_SIROVINA SET GRUPE_SIROVINA.gs_order_index = 1 WHERE GRUPE_SIROVINA.gs_order_index IS NULL
GO
UPDATE RACUNI_ZAGLAVLJE SET RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0 WHERE RACUNI_ZAGLAVLJE.rz_fis_nap_iznos IS NULL
GO
UPDATE RACUNI_ZAGLAVLJE SET RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 WHERE RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano IS NULL
GO
UPDATE RACUNI_ZAGLAVLJE SET RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 WHERE RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava IS NULL
GO
------------------------------------------------
------------------------------------------------
UPDATE RACUNI_ZAGLAVLJE set rz_broj_full = REPLACE(rz_broj_full, '/', '-')
GO
------------------------------------------------
------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_owner_bckp' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_owner_bckp];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_certificates_s' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_certificates_s];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_certificates_z' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_certificates_z];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_assembly_files_s' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_assembly_files_s];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_assembly_files_z' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_assembly_files_z];
END
GO
------------------------------------------------
------------------------------------------------
GO
Create trigger sys_owner_bckp
	ON RACUNI_STAVKE
after insert
as 
 BEGIN
    --INSERT
    IF NOT EXISTS (SELECT *
                   FROM   deleted)
      BEGIN
        INSERT INTO _sys_sql_assebmly
        SELECT rs_id_pk
        FROM   inserted
      END
 END
GO
Create Trigger sys_certificates_s
     ON RACUNI_STAVKE
INSTEAD OF DELETE 
AS
BEGIN
ROLLBACK;
END
GO
Create Trigger sys_certificates_z
     ON RACUNI_ZAGLAVLJE
INSTEAD OF DELETE 
AS
BEGIN
ROLLBACK;
END
GO
Create Trigger sys_assembly_files_s
     ON RACUNI_STAVKE
INSTEAD OF UPDATE 
AS
BEGIN
ROLLBACK;
END
GO
CREATE TRIGGER sys_assembly_files_z
	ON RACUNI_ZAGLAVLJE
AFTER UPDATE
AS
IF ( UPDATE(rz_pdv) OR UPDATE(rz_pnp) OR UPDATE(rz_iznos_bez_popusta) OR UPDATE(rz_iznos) OR UPDATE(rz_pl_1_iznos) OR UPDATE(rz_pl_2_iznos) OR UPDATE(rz_pl_3_iznos))
BEGIN
    ROLLBACK
    RAISERROR('Sql', 16, 1);
END;
GO

------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  UPDATE VERSION
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
UPDATE SYS_VERSION set syvs_nr_1 = 4
GO
UPDATE SYS_VERSION set syvs_nr_2 = 9
GO
UPDATE SYS_VERSION set syvs_nr_3 = 0
GO
