------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------  UPDATE TO CURRENT VERSION
------------------------------------------------
------------------------------------------------
------------------------------------------------
-- NAPOMENA - CIJELA SKRIPTA BE SMIJE SADRZAVATI ZNAK 'HASH'
-- JER SE ON KORISTI KAO SPLIT KARAKTER PRILIKOM IZVRSAVANJA
-- SKRIPTE U BLUE POS PROGRAMU

------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  D R O P        T A B L E S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  W_KS_STAVKE
--------  W_KONOBAR_STOL
--------  USERS
--------  TISKACI
--------  UZIMANJE_GOTOVINE
--------  PORUKE
--------  X_LANGUAGES_ARTIKLI
--------  X_LANGUAGES_MENU_ITEMS
--------  X_LANGUAGES_TOUCH_GRUPE
--------  X_MENU_ITEMS_ARTIKLI
--------  X_MENU_ITEMS
--------  X_LANGUAGES
--------  POSLOVNI_PROSTOR
--------  INVENTURA_BRZA_STAVKE
--------  INVENTURA_BRZA_ZAGLAVLJE

GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'W_KS_STAVKE')
DROP TABLE [dbo].[W_KS_STAVKE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'W_KONOBAR_STOL')
DROP TABLE [dbo].[W_KONOBAR_STOL] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'USERS')
DROP TABLE [dbo].[USERS] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI')
DROP TABLE [dbo].[TISKACI] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UZIMANJE_GOTOVINE')
DROP TABLE [dbo].[UZIMANJE_GOTOVINE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PORUKE')
DROP TABLE [dbo].[PORUKE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'X_LANGUAGES_ARTIKLI')
DROP TABLE [dbo].[X_LANGUAGES_ARTIKLI] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'X_LANGUAGES_MENU_ITEMS')
DROP TABLE [dbo].[X_LANGUAGES_MENU_ITEMS] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'X_LANGUAGES_TOUCH_GRUPE')
DROP TABLE [dbo].[X_LANGUAGES_TOUCH_GRUPE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'X_MENU_ITEMS_ARTIKLI')
DROP TABLE [dbo].[X_MENU_ITEMS_ARTIKLI] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'X_MENU_ITEMS')
DROP TABLE [dbo].[X_MENU_ITEMS] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'X_LANGUAGES')
DROP TABLE [dbo].[X_LANGUAGES] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'POSLOVNI_PROSTOR')
DROP TABLE [dbo].[POSLOVNI_PROSTOR] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_BRZA_STAVKE')
DROP TABLE [dbo].[INVENTURA_BRZA_STAVKE] 
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_BRZA_ZAGLAVLJE')
DROP TABLE [dbo].[INVENTURA_BRZA_ZAGLAVLJE] 
GO

 
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  A D D        T A B L E S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  PRATECI_DOKUMENTI_ZAGLAVLJE
--------  PRATECI_DOKUMENTI_STAVKE
--------  NARUDZBE_ZAGLAVLJE
--------  NARUDZBE_STAVKE
--------  OTVORENI_RACUNI_ZAGLAVLJE
--------  OTVORENI_RACUNI_STAVKE
--------  SYS_JMJ
--------  SMJENE
--------  ADMINISTRATORS
--------  EXTERNAL_DATABASES
--------  SYS_PRINTERI
--------  PONUDA_ZAGLAVLJE
--------  PONUDA_STAVKE
--------  NABAVNI_NALOG_ZAGLAVLJE
--------  NABAVNI_NALOG_STAVKE
--------  KONZUMACIJA_ZAGLAVLJE
--------  KONZUMACIJA_STAVKE
--------  SIROVINE_EXTERANAL
--------  PRIMKE_EXTERNAL_ZAGLAVLJE
--------  PRIMKE_EXTERNAL_STAVKE



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_ZAGLAVLJE')
CREATE TABLE [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE](
	[pdz_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pdz_broj] [int] NULL,
	[pdz_broj_full] [nvarchar](50) NULL,
	[pdz_vrijeme] [datetime] NULL,
	[pdz_dan] [datetime] NULL,
	[pdz_kasa_id_fk] [int] NULL,
	[pdz_konobar_id_fk] [int] NULL,
	[pdz_stol_id_fk] [int] NULL,
	[pdz_tvrtka_id_fk] [int] NULL,
	[pdz_narucitelj_id_fk] [int] NULL,
	[pdz_popust] [decimal](12, 2) NULL,
	[pdz_iznos_bez_popusta] [decimal](12, 2) NULL,
	[pdz_iznos] [decimal](12, 2) NULL,
	[pdz_pdv] [decimal](12, 2) NULL,
	[pdz_pnp] [decimal](12, 2) NULL,
	[pdz_napomena] [nvarchar](200) NULL,
	[pdz_fis_vrijeme_slanja] [datetime] NULL,
	[pdz_fis_vrijeme_obrade] [datetime] NULL,
	[pdz_fis_uuid] [nvarchar](50) NULL,
	[pdz_fis_zastitni_kod] [nvarchar](40) NULL,
	[pdz_fis_jir] [nvarchar](50) NULL,
	[pdz_fis_ozn_pos_pros] [nvarchar](50) NULL,
	[pdz_fis_ozn_nap_uredaja] [nvarchar](50) NULL,
	[pdz_fis_naknadna_dostava] [bit] NULL,
	[pdz_fis_storno_sign] [nvarchar](1) NULL,
	[pdz_fis_source_id] [int] NULL,
  CONSTRAINT [PK_PRATECI_DOKUMENTI_ZAGLAVLJE] PRIMARY KEY CLUSTERED ([pdz_id_pk]),
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_KASE] FOREIGN KEY ([pdz_kasa_id_fk]) 
			REFERENCES [dbo].[KASE] ([ks_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([pdz_konobar_id_fk]) 
			REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([pdz_narucitelj_id_fk]) 
			REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([pdz_stol_id_fk]) 
			REFERENCES [dbo].[STOLOVI] ([st_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([pdz_tvrtka_id_fk]) 
			REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_PRATECI_DOKUMENTI_ZAGLAVLJE1] FOREIGN KEY ([pdz_fis_source_id]) 
			REFERENCES [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE] ([pdz_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION
)
ON [PRIMARY]
GO


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_STAVKE')
CREATE TABLE [dbo].[PRATECI_DOKUMENTI_STAVKE](
	[pds_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pds_pdz_id_fk] [int] NULL,
	[pds_artikal_id_fk] [int] NULL,
	[pds_gpdv_id_fk] [int] NULL,
	[pds_gpnp_id_fk] [int] NULL,
	[pds_popust] [decimal](12, 3) NULL,
	[pds_cijena_bez_popusta] [decimal](12, 2) NULL,
	[pds_cijena] [decimal](12, 2) NULL,
	[pds_kolicina] [decimal](12, 2) NULL,
	[pds_iznos_bez_popusta] [decimal](12, 2) NULL,
	[pds_iznos] [decimal](12, 2) NULL,
	[pds_pdv] [decimal](12, 2) NULL,
	[pds_pnp] [decimal](12, 2) NULL,
	[pds_napomena] [nvarchar](30) NULL,
  CONSTRAINT [PK_PRATECI_DOKUMENTI_STAVKE] PRIMARY KEY CLUSTERED ([pds_id_pk]),
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_ARTIKLI] FOREIGN KEY ([pds_artikal_id_fk]) 
			REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_GRUPE_PDV] FOREIGN KEY ([pds_gpdv_id_fk]) 
			REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_GRUPE_PNP] FOREIGN KEY ([pds_gpnp_id_fk]) 
			REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_PRATECI_DOKUMENTI_ZAGLAVLJE] FOREIGN KEY ([pds_pdz_id_fk]) 
			REFERENCES [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE] ([pdz_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION
)
ON [PRIMARY]
GO

 


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_ZAGLAVLJE')
CREATE TABLE [dbo].[NARUDZBE_ZAGLAVLJE] (
  [nz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [nz_action_type] nvarchar(15) NULL,
  [nz_broj_full] int NULL,
  [nz_broj_dnevni] int NULL,
  [nz_vrijeme] datetime NULL,
  [nz_dan] datetime NULL,
  [nz_mi_id_fk] int NULL,
  [nz_kasa_id_fk] int NULL,
  [nz_konobar_id_fk] int NULL,
  [nz_stol_id_fk] int NULL,
  [nz_iznos] decimal(18, 2) NULL,
  CONSTRAINT [PK_NARUDZBE_ZAGLAVLJE] PRIMARY KEY CLUSTERED ([nz_id_pk]),
  CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_KASE] FOREIGN KEY ([nz_kasa_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([nz_konobar_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_MJESTA_IZDAVANJA] FOREIGN KEY ([nz_mi_id_fk]) 
  REFERENCES [dbo].[MJESTA_IZDAVANJA] ([mi_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_NARUDZBE_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([nz_stol_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
)
ON [PRIMARY]
GO




GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE')
CREATE TABLE [dbo].[NARUDZBE_STAVKE] (
  [ns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ns_nz_id_fk] int NULL,
  [ns_ar_id_fk] int NULL,
  [ns_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ns_ar_cijena] decimal(18, 2) NULL,
  [ns_kolicina] decimal(18, 4) NULL,
  [ns_iznos] decimal(18, 2) NULL,
  [ns_slijed] nvarchar(15) NULL,
  CONSTRAINT [PK_NARUDZBE_STAVKE] PRIMARY KEY CLUSTERED ([ns_id_pk]),
  CONSTRAINT [FK_NARUDZBE_STAVKE_ARTIKLI] FOREIGN KEY ([ns_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_NARUDZBE_STAVKE_NARUDZBE_ZAGLAVLJE] FOREIGN KEY ([ns_nz_id_fk]) 
  REFERENCES [dbo].[NARUDZBE_ZAGLAVLJE] ([nz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
)
ON [PRIMARY]
GO


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_ZAGLAVLJE')
CREATE TABLE [dbo].[OTVORENI_RACUNI_ZAGLAVLJE] (
  [wks_id_pk] int IDENTITY(1, 1) NOT NULL,
  [wks_konobar_id_fk] int NULL,
  [wks_stol_id_fk] int NULL,
  [wks_vrijeme] datetime NULL,
  [wks_napomena] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [wks_is_used] bit NULL,
  CONSTRAINT [PK_OTVORENI_RACUNI_ZAGLAVLJE] PRIMARY KEY CLUSTERED ([wks_id_pk]),
  CONSTRAINT [FK_OTVORENI_RACUNI_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([wks_konobar_id_fk]) 
  REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_OTVORENI_RACUNI_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([wks_stol_id_fk]) 
  REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
)
ON [PRIMARY]
GO



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE')
CREATE TABLE [dbo].[OTVORENI_RACUNI_STAVKE] (
  [wkss_id_pk] int IDENTITY(1, 1) NOT NULL,
  [wkss_wks_id_fk] int NULL,
  [wkss_artikal_id_fk] int NULL,
  [wkss_kolicina] decimal(12, 2) NULL,
  [wkss_popust] decimal(12, 3) NULL,
  [wkss_cijena_bez_popusta] decimal(12, 2) NULL,
  [wkss_cijena] decimal(12, 2) NULL,
  [wkss_pdv] decimal(12, 2) NULL,
  [wkss_pnp] decimal(12, 2) NULL,
  [wkss_iznos_bez_popusta] decimal(12, 2) NULL,
  [wkss_iznos] decimal(12, 2) NULL,
  [wkss_nar_naruceno] bit NULL,
  [wkss_nar_ns_id_pk] int NULL,
  [wkss_nar_napomena] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_vrijeme_izdavanja] datetime NULL,
  [wkss_nar_vrijeme_prihvacanja] datetime NULL,
  [wkss_nar_vrijeme_spremnosti] datetime NULL,
  [wkss_nar_vrijeme_dostave] datetime NULL,
  [wkss_nar_slijed_name] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_slijed_oznaka] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [wkss_nar_slijed_priority] int NULL,
  [wkss_nar_status] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [wkss_pdv_id_fk] int NULL,
  [wkss_pnp_id_fk] int NULL,
  CONSTRAINT [PK_OTVORENI_RACUNI_STAVKE] PRIMARY KEY CLUSTERED ([wkss_id_pk]),
  CONSTRAINT [FK_OTVORENI_RACUNI_STAVKE_ARTIKLI] FOREIGN KEY ([wkss_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_OTVORENI_RACUNI_STAVKE_OTVORENI_RACUNI_ZAGLAVLJE] FOREIGN KEY ([wkss_wks_id_fk]) 
  REFERENCES [dbo].[OTVORENI_RACUNI_ZAGLAVLJE] ([wks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
)
ON [PRIMARY]
GO



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SYS_JMJ')
CREATE TABLE [dbo].[SYS_JMJ] (
  [sy_jmj_name] nvarchar(10) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO




GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SMJENE')
CREATE TABLE [dbo].[SMJENE] (
  [sm_id_pk] int IDENTITY(1, 1) NOT NULL,
  [sm_name] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [sm_start] datetime NULL,
  [sm_end] datetime NULL,
  CONSTRAINT [PK_SMJENE] PRIMARY KEY CLUSTERED ([sm_id_pk])
)
ON [PRIMARY]
GO


 


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ADMINISTRATORS')
CREATE TABLE [dbo].[ADMINISTRATORS] (
  [adm_id_pk] int IDENTITY(1, 1) NOT NULL,
  [adm_name] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [adm_password] int NULL,
  [adm_rf_id] nvarchar(25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  CONSTRAINT [PK_SYS_ADMINISTRATOR] PRIMARY KEY CLUSTERED ([adm_id_pk]),
  CONSTRAINT [UQ_SYS_ADMINISTRATOR_adm_name] UNIQUE ([adm_name]),
  CONSTRAINT [UQ_SYS_ADMINISTRATOR_adm_password] UNIQUE ([adm_password])
)
ON [PRIMARY]
GO
if not exists(select 1 from ADMINISTRATORS)
begin
INSERT INTO [dbo].[ADMINISTRATORS] ([adm_name], [adm_password], [adm_rf_id])
VALUES (N'Administrator', 123, null)
end
GO




GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'EXTERNAL_DATABASES')
CREATE TABLE [dbo].[EXTERNAL_DATABASES] (
  [ext_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ext_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ext_description] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [ext_db_host] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ext_db_name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_db_user] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_db_password] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_index] int,
  CONSTRAINT [PK_EXTERNAL_DATABASES] PRIMARY KEY CLUSTERED ([ext_id_pk])
)
ON [PRIMARY]
GO




GO
DECLARE @SYS_PRINTERS_EXISTS int
SET @SYS_PRINTERS_EXISTS = 0

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SYS_PRINTERI')
SET @SYS_PRINTERS_EXISTS = 1

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SYS_PRINTERI')
CREATE TABLE [dbo].[SYS_PRINTERI] (
  [sypr_id_pk] int NULL,
  [sypr_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [sypr_N] int NULL,
  [sypr_B1] int NULL,
  [sypr_B2] int NULL,
  [sypr_cntr_text_normal] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_text_bold_1] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_text_bold_2] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_ladica] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_rezac] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]



GO
if not exists(select * from [SYS_PRINTERI] where sypr_name = 'EPSON TM U950')
BEGIN
	INSERT INTO [SYS_PRINTERI] ([sypr_id_pk], [sypr_name], [sypr_N], [sypr_B1], [sypr_B2], [sypr_cntr_text_normal], [sypr_cntr_text_bold_1], [sypr_cntr_text_bold_2], [sypr_cntr_ladica], [sypr_cntr_rezac])
	VALUES (11, N'EPSON TM U950', 40, 20, 20, N'CHR(27) + CHR(33) + CHR(1)', N'CHR(27) + CHR(33) + CHR(41)', N'CHR(27) + CHR(33) + CHR(61)', N'CHR(27) + p + CHR(0) + CHR(60) + CHR(240)', N'CHR(27) + i')
END
GO
if not exists(select * from [SYS_PRINTERI] where [sypr_id_pk] = 12)
BEGIN
	insert into SYS_PRINTERI (sypr_id_pk, sypr_name, sypr_N, sypr_B1, sypr_B2, sypr_cntr_text_normal, sypr_cntr_text_bold_1, sypr_cntr_text_bold_2, sypr_cntr_ladica, sypr_cntr_rezac) 
	values (12, 'BLUETOOTH 58mm', 42, 32, 16, 'CHR(27) + CHR(33) + CHR(1)', 'CHR(27) + CHR(33) + CHR(10)', 'CHR(27) + CHR(33) + CHR(40)', null, null)
END
GO
if not exists(select * from [SYS_PRINTERI] where [sypr_id_pk] = 13)
BEGIN
	INSERT INTO [dbo].[SYS_PRINTERI] ([sypr_id_pk], [sypr_name], [sypr_N], [sypr_B1], [sypr_B2], [sypr_cntr_text_normal], [sypr_cntr_text_bold_1], [sypr_cntr_text_bold_2], [sypr_cntr_ladica], [sypr_cntr_rezac])
	VALUES (13, N'SAMSUNG SRP 275', 40, 16, 16, N'CHR(27) + CHR(64)', N'CHR(27) + CHR(33) + CHR(40)', N'CHR(27) + CHR(33) + CHR(60)', N'CHR(27) + CHR(112) + CHR(00) + CHR(50) + CHR(250)', N'CHR(29) + CHR(86) + CHR(01) + CHR(49)')
END
GO


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PONUDA_ZAGLAVLJE')
BEGIN
CREATE TABLE [dbo].[PONUDA_ZAGLAVLJE](
	[pnz_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pnz_broj] [int] NULL,
	[pnz_nadnevak] [datetime] NULL,
	[pnz_kn_id_fk] [int] NULL,
	[pnz_tv_id_fk] [int] NULL,
	[pnz_napomena] [nvarchar](100) COLLATE Croatian_CI_AS NULL,
 CONSTRAINT [PK_PONUDA_ZAGLAVLJE] PRIMARY KEY CLUSTERED 
([pnz_id_pk] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_ZAGLAVLJE_KONOBARI] FOREIGN KEY([pnz_kn_id_fk]) REFERENCES [dbo].[KONOBARI] ([kn_id_pk])
ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE] CHECK CONSTRAINT [FK_PONUDA_ZAGLAVLJE_KONOBARI]
ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_ZAGLAVLJE_TVRTKE] FOREIGN KEY([pnz_tv_id_fk]) REFERENCES [dbo].[TVRTKE] ([tv_id_pk])
ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE] CHECK CONSTRAINT [FK_PONUDA_ZAGLAVLJE_TVRTKE]
END
GO





GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PONUDA_STAVKE')
BEGIN
CREATE TABLE [dbo].[PONUDA_STAVKE](
	[pns_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pns_ponuda_id_fk] [int] NULL,
	[pns_artikal_id_fk] [int] NULL,
	[pns_cijena_bez_popusta] [decimal](16, 2) NULL,
	[pns_cijena] [decimal](16, 2) NULL,
	[pns_kolicina] [decimal](16, 2) NULL,
	[pns_iznos_bez_popusta] [decimal](16, 2) NULL,
	[pns_iznos] [decimal](16, 2) NULL,
	[pns_pdv] [decimal](16, 2) NULL,
	[pns_pnp] [decimal](16, 2) NULL,
	[pns_gpdv_id_fk] [int] NULL,
	[pns_gpnp_id_fk] [int] NULL,
	[pns_popust] [decimal](12, 3) NULL,
 CONSTRAINT [PK_PONUDA_STAVKE] PRIMARY KEY CLUSTERED 
([pns_id_pk] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[PONUDA_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_STAVKE_ARTIKLI] FOREIGN KEY([pns_artikal_id_fk]) REFERENCES [dbo].[ARTIKLI] ([ar_id_pk])
ALTER TABLE [dbo].[PONUDA_STAVKE] CHECK CONSTRAINT [FK_PONUDA_STAVKE_ARTIKLI]
ALTER TABLE [dbo].[PONUDA_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PDV] FOREIGN KEY([pns_gpdv_id_fk]) REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk])
ALTER TABLE [dbo].[PONUDA_STAVKE] CHECK CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PDV]
ALTER TABLE [dbo].[PONUDA_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PNP] FOREIGN KEY([pns_gpnp_id_fk]) REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk])
ALTER TABLE [dbo].[PONUDA_STAVKE] CHECK CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PNP]
ALTER TABLE [dbo].[PONUDA_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_STAVKE_PONUDA_ZAGLAVLJE] FOREIGN KEY([pns_ponuda_id_fk]) REFERENCES [dbo].[PONUDA_ZAGLAVLJE] ([pnz_id_pk])
ALTER TABLE [dbo].[PONUDA_STAVKE] CHECK CONSTRAINT [FK_PONUDA_STAVKE_PONUDA_ZAGLAVLJE]
END
GO





GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NABAVNI_NALOG_ZAGLAVLJE')
BEGIN
CREATE TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE](
	[nnz_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[nnz_broj] [int] NULL,
	[nnz_nadnevak] [datetime] NULL,
	[nnz_kn_id_fk] [int] NULL,
	[nnz_do_id_fk] [int] NULL,
	[nnz_napomena] [nvarchar](100) COLLATE Croatian_CI_AS NULL,
 CONSTRAINT [PK_NABAVNI_NALOG_ZAGLAVLJE] PRIMARY KEY CLUSTERED 
([nnz_id_pk] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE]  WITH CHECK ADD  CONSTRAINT [FK_NABAVNI_NALOG_ZAGLAVLJE_DOBAVLJACI] FOREIGN KEY([nnz_do_id_fk]) REFERENCES [dbo].[DOBAVLJACI] ([do_id_pk])
ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE] CHECK CONSTRAINT [FK_NABAVNI_NALOG_ZAGLAVLJE_DOBAVLJACI]
ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE]  WITH CHECK ADD  CONSTRAINT [FK_NABAVNI_NALOG_ZAGLAVLJE_KONOBARI] FOREIGN KEY([nnz_kn_id_fk]) REFERENCES [dbo].[KONOBARI] ([kn_id_pk])
ALTER TABLE [dbo].[NABAVNI_NALOG_ZAGLAVLJE] CHECK CONSTRAINT [FK_NABAVNI_NALOG_ZAGLAVLJE_KONOBARI]
END
GO





GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NABAVNI_NALOG_STAVKE')
BEGIN
CREATE TABLE [dbo].[NABAVNI_NALOG_STAVKE](
	[nns_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[nns_nabavni_nalog_id_fk] [int] NULL,
	[nns_sirovina_id_fk] [int] NULL,
	[nns_stanje_skladista] [decimal](16, 2) NULL,
	[nns_kolicina] [decimal](16, 2) NULL,
 CONSTRAINT [PK_NABAVNI_NALOG_STAVKE] PRIMARY KEY CLUSTERED 
([nns_id_pk] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_NABAVNI_NALOG_STAVKE_NABAVNI_NALOG_ZAGLAVLJE] FOREIGN KEY([nns_nabavni_nalog_id_fk]) REFERENCES [dbo].[NABAVNI_NALOG_ZAGLAVLJE] ([nnz_id_pk])
ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE] CHECK CONSTRAINT [FK_NABAVNI_NALOG_STAVKE_NABAVNI_NALOG_ZAGLAVLJE]
ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_NABAVNI_NALOG_STAVKE_SIROVINE] FOREIGN KEY([nns_sirovina_id_fk]) REFERENCES [dbo].[SIROVINE] ([si_id_pk])
ALTER TABLE [dbo].[NABAVNI_NALOG_STAVKE] CHECK CONSTRAINT [FK_NABAVNI_NALOG_STAVKE_SIROVINE]
END
GO



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'KONZUMACIJA_ZAGLAVLJE')
CREATE TABLE [dbo].[KONZUMACIJA_ZAGLAVLJE] (
  [kzz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [kzz_racun_id_fk] int NULL,
  [kzz_konobar_id_fk] int NULL,
  [kzz_stol_id_fk] int NULL,
  [kzz_tvrtka_id_fk] int NULL,
  [kzz_narucitelj_id_fk] int NULL,
  [kzz_kasa_id_fk] int NULL,
  [kzz_vrijeme] datetime NULL,
  [kzz_nadnevak] datetime NULL,
  [kzz_broj_dnevni] int NULL,
  [kzz_broj_full] int NULL,
  [kzz_popust] decimal(16, 2) NULL,
  [kzz_iznos_bez_popusta] decimal(16, 2) NULL,
  [kzz_iznos] decimal(16, 2) NULL,
  [kzz_pdv] decimal(16, 2) NULL,
  [kzz_pnp] decimal(16, 2) NULL,
  [kzz_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  CONSTRAINT [PK_KONZUMACIJA_ZAGLAVLJE] PRIMARY KEY CLUSTERED ([kzz_id_pk]),
  CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_RACUNI_ZAGLAVLJE] FOREIGN KEY ([kzz_racun_id_fk]) REFERENCES [dbo].[RACUNI_ZAGLAVLJE] ([rz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_KONOBARI] FOREIGN KEY ([kzz_konobar_id_fk]) REFERENCES [dbo].[KONOBARI] ([kn_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_STOLOVI] FOREIGN KEY ([kzz_stol_id_fk]) REFERENCES [dbo].[STOLOVI] ([st_id_pk]) 
   ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([kzz_tvrtka_id_fk]) REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([kzz_narucitelj_id_fk]) REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_KONZUMACIJA_ZAGLAVLJE_KASA] FOREIGN KEY ([kzz_kasa_id_fk]) REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
)
ON [PRIMARY]
GO




GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'KONZUMACIJA_STAVKE')
CREATE TABLE [dbo].[KONZUMACIJA_STAVKE] (
  [kzs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [kzs_kzz_id_fk] int NULL,
  [kzs_artikal_id_fk] int NULL,
  [kzs_kolicina] decimal(16, 2) NULL,
  [kzs_cijena_bez_popusta] decimal(16, 2) NULL,
  [kzs_cijena] decimal(16, 2) NULL,
  [kzs_popust] decimal(16, 2) NULL,
  [kzs_iznos_bez_popusta] decimal(16, 2) NULL,
  [kzs_iznos] decimal(16, 2) NULL,
  [kzs_pdv] decimal(16, 2) NULL,
  [kzs_pnp] decimal(16, 2) NULL,
  [kzs_gpdv_id_fk] int NULL,
  [kzs_gpnp_id_fk] int NULL,
  [kzs_napomena] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  CONSTRAINT [PK_KONZUMACIJA_STAVKE] PRIMARY KEY CLUSTERED ([kzs_id_pk]),
  CONSTRAINT [FK_KONZUMACIJA_STAVKE_ARTIKLI] FOREIGN KEY ([kzs_artikal_id_fk]) REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]), 
  CONSTRAINT [FK_KONZUMACIJA_STAVKE_PDV_GRUPA] FOREIGN KEY ([kzs_gpdv_id_fk]) REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]), 
  CONSTRAINT [FK_KONZUMACIJA_STAVKE_PNP_GRUPA] FOREIGN KEY ([kzs_gpnp_id_fk]) REFERENCES [dbo].[GRUPE_PNP] ([gpnp_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
  CONSTRAINT [FK_KONZUMACIJA_STAVKE_KONZUMACIJA_ZAGLAVLJE] FOREIGN KEY ([kzs_kzz_id_fk]) REFERENCES [dbo].[KONZUMACIJA_ZAGLAVLJE] ([kzz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
)
ON [PRIMARY]
GO





GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE_EXTERANAL')
BEGIN
CREATE TABLE [dbo].[SIROVINE_EXTERANAL](
	[sxt_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[sxt_sifra] [nvarchar](20) NULL,
	[sxt_barcode_ean] [nvarchar](20) NULL,
	[sxt_naziv] [nvarchar](50) NULL,
	[sxt_jmj] [nvarchar](10) NULL,
	[sxt_jmj_paket_kol] [decimal](12, 2) NULL,
	[sxt_grupa] [nvarchar](30) NULL,
	[sxt_napomena] [nvarchar](50) NULL,
	[sxt_sir_id_fk] [int] NULL,
    CONSTRAINT [PK_SIROVINE_EXTERANAL] PRIMARY KEY CLUSTERED 
(
	[sxt_id_pk] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[SIROVINE_EXTERANAL]  WITH CHECK ADD  CONSTRAINT [FK_SIROVINE_EXTERANAL_SIROVINE] FOREIGN KEY([sxt_sir_id_fk]) REFERENCES [dbo].[SIROVINE] ([si_id_pk])
ALTER TABLE [dbo].[SIROVINE_EXTERANAL] CHECK CONSTRAINT [FK_SIROVINE_EXTERANAL_SIROVINE]
END
GO
IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'UQ_SIROVINE_EXTERANAL_sxt_sifra')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX UQ_SIROVINE_EXTERANAL_sxt_sifra ON SIROVINE_EXTERANAL(sxt_sifra) WHERE sxt_sifra IS NOT NULL
	END
GO
IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'UQ_SIROVINE_EXTERANAL_sxt_barcode_ean')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX UQ_SIROVINE_EXTERANAL_sxt_barcode_ean ON SIROVINE_EXTERANAL(sxt_barcode_ean) WHERE sxt_barcode_ean IS NOT NULL
	END
GO



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_EXTERNAL_ZAGLAVLJE')
BEGIN
CREATE TABLE [dbo].[PRIMKE_EXTERNAL_ZAGLAVLJE](
	[pez_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pez_source] [nvarchar](20) NULL,
	[pez_dob_naziv] [nvarchar](50) NULL,
	[pez_dob_adresa] [nvarchar](50) NULL,
	[pez_dob_mjesto] [nvarchar](50) NULL,
	[pez_dob_oib] [nvarchar](20) NULL,
	[pez_dob_iban] [nvarchar](20) NULL,
	[pez_broj] [nvarchar](30) NULL,
	[pez_datum] [datetime] NULL,
	[pez_datum_dospijeca] [datetime] NULL,
	[pez_datum_knjizenja] [datetime] NULL,
	[pez_datum_isporuke] [datetime] NULL,
	[pez_uk_VPC] [decimal](12, 2) NULL,
	[pez_uk_PDV] [decimal](12, 2) NULL,
	[pez_uk_POV_NAK] [decimal](12, 2) NULL,
	[pez_uk_MPC] [decimal](12, 2) NULL,
	[pez_note_1] [nvarchar](50) NULL,
	[pez_note_2] [nvarchar](50) NULL,
	[pez_note_3] [nvarchar](50) NULL,
	[pez_note_4] [nvarchar](50) NULL,
	[pez_status] [nvarchar](20) NULL,
	[pez_napomena] [nvarchar](50) NULL,
 CONSTRAINT [PK_PRIMKE_EXTERNAL_ZAGLAVLJE] PRIMARY KEY CLUSTERED 
(
	[pez_id_pk] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO




GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_EXTERNAL_STAVKE')
BEGIN
CREATE TABLE [dbo].[PRIMKE_EXTERNAL_STAVKE](
	[pes_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pes_pez_id_fk] [int] NULL,
	[pes_si_sifra] [nvarchar](50) NULL,
	[pes_si_barcode] [nvarchar](50) NULL,
	[pes_si_naziv] [nvarchar](50) NULL,
	[pes_si_jmj] [nvarchar](10) NULL,
	[pes_si_cijena_vpc] [decimal](12, 2) NULL,
	[pes_si_pov_nak] [decimal](12, 2) NULL,
	[pes_kolicina] [decimal](12, 3) NULL,
	[pes_rabat_postotak] [decimal](12, 2) NULL,
	[pes_porez_postotak] [int] NULL,
	[pes_uk_VPC] [decimal](12, 2) NULL,
	[pes_uk_PDV] [decimal](12, 2) NULL,
	[pes_uk_POV_NAK] [decimal](12, 2) NULL,
	[pes_uk_MPC] [decimal](12, 2) NULL,
 CONSTRAINT [PK_PRIMKE_EXTERNAL_STAVKE] PRIMARY KEY CLUSTERED 
(
	[pes_id_pk] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[PRIMKE_EXTERNAL_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_PRIMKE_EXTERNAL_STAVKE_PRIMKE_EXTERNAL_ZAGLAVLJE] FOREIGN KEY([pes_pez_id_fk]) REFERENCES [dbo].[PRIMKE_EXTERNAL_ZAGLAVLJE] ([pez_id_pk])
ALTER TABLE [dbo].[PRIMKE_EXTERNAL_STAVKE] CHECK CONSTRAINT [FK_PRIMKE_EXTERNAL_STAVKE_PRIMKE_EXTERNAL_ZAGLAVLJE]
END
GO


GO
IF (OBJECT_ID('dbo.FK_RACUNI_STAVKE_RACUNI_STAVKE1', 'F') IS NOT NULL)
BEGIN
	ALTER TABLE [dbo].[RACUNI_STAVKE] DROP CONSTRAINT [FK_RACUNI_STAVKE_RACUNI_STAVKE1]
END
GO




------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  A D D        C O L U M N S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  ARTIKLI.ar_index
--------  ARTIKLI.ar_cijena_popust_2
--------  ARTIKLI.ar_cijena_popust_3
--------  SIROVINE.si_sifra
--------  SIROVINE.si_active
--------  SIROVINE.si_povratna_naknada
--------  SIROVINE.si_kalo
--------  SIROVINE.si_pdv_id_fk
--------  TVRTKE.tv_state
--------  TVRTKE.tv_porezni_broj
--------  TVRTKE.tv_email
--------  TVRTKE.tv_adresa_broj
--------  TVRTKE.tv_mjesto_postanski_broj
--------  TVRTKE.tv_tel
--------  TVRTKE.tv_iban
--------  TVRTKE.sifra
--------  DOBAVLJACI.do_state
--------  DOBAVLJACI.do_porezni_broj
--------  DOBAVLJACI.do_sifra
--------  NARUCITELJI.na_kartica
--------  NARUCITELJI.na_popust
--------  GRUPE_TOUCH_SCREEN.gt_color_index
--------  GRUPE_TOUCH_SCREEN_ARTIKLI.gt_ar_order
--------  GRUPE_SIROVINA.gs_sysk_id_fk
--------  GRUPE_ARTIKALA.ga_syak_id_fk
--------  SYS_PLACANJA.sypl_sort
--------  NACINI_PLACANJA.np_sort
--------  PRIMKE_ZAGLAVLJE.pr_povratna_naknada
--------  PRIMKE_ZAGLAVLJE.pr_status
--------  RACUNI_STAVKE.rs_menu_id
--------  PRIMKE_STAVKE.ps_tot_povratna_naknada
--------  PRIMKE_STAVKE.ps_si_povratna_naknada
--------  IZDATNICE_STAVKE.is_tot_pov_nak
--------  OTPISI_STAVKE.os_tot_pov_nak
--------  INVENTURA_STAVKE.ins_fin_stanje_zateceno
--------  INVENTURA_STAVKE.ins_fin_stanje_kasa
--------  INVENTURA_STAVKE.ins_fin_stanje_razlika
--------  INVENTURA_STAVKE.ins_pov_nak_razlika
--------  INVENTURA_ZAGLAVLJE.in_proknjizeno
--------  INVENTURA_ZAGLAVLJE.in_broj
--------  ACTIVITY_LOG.ac_korisnik
--------  NARUDZBE_ZAGLAVLJE.nz_popust
--------  NARUDZBE_ZAGLAVLJE.nz_iznos_bez_popusta
--------  NARUDZBE_STAVKE.ns_popust
--------  NARUDZBE_STAVKE.ns_iznos_bez_popusta
--------  NARUDZBE_STAVKE.ns_vrijeme_izdavanja
--------  NARUDZBE_STAVKE.ns_vrijeme_prihvacanja
--------  NARUDZBE_STAVKE.ns_vrijeme_spremnosti
--------  NARUDZBE_STAVKE.ns_vrijeme_dostave
--------  NARUDZBE_STAVKE.ns_status
--------  MJESTA_IZDAVANJA.mi_vezano
--------  MJESTA_IZDAVANJA.mi_vezano_ispis
--------  RACUNI_ZAGLAVLJE.rz_prat_dok_id_fk
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_naruceno
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_napomena
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_izdavanja
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_prihvacanja
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_spremnosti
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_dostave
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_name
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_oznaka
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_priority
--------  OTVORENI_RACUNI_STAVKE.wkss_nar_status
--------  OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk
--------  OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_index')
ALTER TABLE [dbo].[ARTIKLI] ADD ar_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_cijena_popust_2')
ALTER TABLE [dbo].[ARTIKLI] ADD ar_cijena_popust_2 decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_cijena_popust_3')
ALTER TABLE [dbo].[ARTIKLI] ADD ar_cijena_popust_3 decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE' AND COLUMN_NAME = 'si_sifra')
ALTER TABLE [dbo].[SIROVINE] ADD si_sifra nvarchar(20) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE' AND COLUMN_NAME = 'si_active')
ALTER TABLE [dbo].[SIROVINE] ADD si_active bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE' AND COLUMN_NAME = 'si_povratna_naknada')
ALTER TABLE [dbo].[SIROVINE] ADD si_povratna_naknada decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE' AND COLUMN_NAME = 'si_kalo')
ALTER TABLE [dbo].[SIROVINE] ADD si_kalo decimal(4,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIROVINE' AND COLUMN_NAME = 'si_pdv_id_fk')
ALTER TABLE [dbo].[SIROVINE] ADD si_pdv_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_state')
ALTER TABLE [dbo].[TVRTKE] ADD tv_state nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_porezni_broj')
ALTER TABLE [dbo].[TVRTKE] ADD tv_porezni_broj nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_email')
ALTER TABLE [dbo].[TVRTKE] ADD tv_email nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_adresa_broj')
ALTER TABLE [dbo].[TVRTKE] ADD tv_adresa_broj nvarchar(10)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_mjesto_postanski_broj')
ALTER TABLE [dbo].[TVRTKE] ADD tv_mjesto_postanski_broj int
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_tel')
ALTER TABLE [dbo].[TVRTKE] ADD tv_tel nvarchar(20)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_iban')
ALTER TABLE [dbo].[TVRTKE] ADD tv_iban nvarchar(30)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_sifra')
ALTER TABLE [dbo].[TVRTKE] ADD tv_sifra nvarchar(30)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DOBAVLJACI' AND COLUMN_NAME = 'do_state')
ALTER TABLE [dbo].[DOBAVLJACI] ADD do_state nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DOBAVLJACI' AND COLUMN_NAME = 'do_porezni_broj')
ALTER TABLE [dbo].[DOBAVLJACI] ADD do_porezni_broj nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DOBAVLJACI' AND COLUMN_NAME = 'do_sifra')
ALTER TABLE [dbo].[DOBAVLJACI] ADD do_sifra nvarchar (25) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUCITELJI' AND COLUMN_NAME = 'na_kartica')
ALTER TABLE [dbo].[NARUCITELJI] ADD na_kartica nvarchar (25) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUCITELJI' AND COLUMN_NAME = 'na_popust')
ALTER TABLE [dbo].[NARUCITELJI] ADD na_popust decimal (5,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_TOUCH_SCREEN' AND COLUMN_NAME = 'gt_color_index')
ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN] ADD gt_color_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_TOUCH_SCREEN_ARTIKLI' AND COLUMN_NAME = 'gt_ar_order')
ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI] ADD gt_ar_order int NULL 
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_SIROVINA' AND COLUMN_NAME = 'gs_sysk_id_fk')
ALTER TABLE [dbo].[GRUPE_SIROVINA] ADD gs_sysk_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_ARTIKALA' AND COLUMN_NAME = 'ga_syak_id_fk')
ALTER TABLE [dbo].[GRUPE_ARTIKALA] ADD ga_syak_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SYS_PLACANJA' AND COLUMN_NAME = 'sypl_sort')
ALTER TABLE [dbo].[SYS_PLACANJA] ADD sypl_sort int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NACINI_PLACANJA' AND COLUMN_NAME = 'np_sort')
ALTER TABLE [dbo].[NACINI_PLACANJA] ADD np_sort int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_povratna_naknada')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] ADD pr_povratna_naknada decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_status')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] ADD pr_status bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_STAVKE' AND COLUMN_NAME = 'rs_menu_id')
ALTER TABLE [dbo].[RACUNI_STAVKE] ADD rs_menu_id int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_STAVKE' AND COLUMN_NAME = 'ps_tot_povratna_naknada')
ALTER TABLE [dbo].[PRIMKE_STAVKE] ADD ps_tot_povratna_naknada decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_STAVKE' AND COLUMN_NAME = 'ps_si_povratna_naknada')
ALTER TABLE [dbo].[PRIMKE_STAVKE] ADD ps_si_povratna_naknada decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IZDATNICE_STAVKE' AND COLUMN_NAME = 'is_tot_pov_nak')
ALTER TABLE [dbo].[IZDATNICE_STAVKE] ADD is_tot_pov_nak decimal(10,2)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTPISI_STAVKE' AND COLUMN_NAME = 'os_tot_pov_nak')
ALTER TABLE [dbo].[OTPISI_STAVKE] ADD os_tot_pov_nak decimal(10,2)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'ins_fin_stanje_zateceno')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD ins_fin_stanje_zateceno decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'ins_fin_stanje_kasa')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD ins_fin_stanje_kasa decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'ins_fin_stanje_razlika')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD ins_fin_stanje_razlika decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'ins_pov_nak_razlika')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD ins_pov_nak_razlika decimal(8,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'in_proknjizeno')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD in_proknjizeno bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'in_broj')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD in_broj int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ACTIVITY_LOG' AND COLUMN_NAME = 'ac_korisnik')
ALTER TABLE [dbo].[ACTIVITY_LOG] ADD ac_korisnik nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_ZAGLAVLJE' AND COLUMN_NAME = 'nz_popust')
ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE] ADD nz_popust decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_ZAGLAVLJE' AND COLUMN_NAME = 'nz_iznos_bez_popusta')
ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE] ADD nz_iznos_bez_popusta decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_popust')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_popust decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_iznos_bez_popusta')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_iznos_bez_popusta decimal (12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_vrijeme_izdavanja')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_vrijeme_izdavanja datetime
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_vrijeme_prihvacanja')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_vrijeme_prihvacanja datetime
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_vrijeme_spremnosti')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_vrijeme_spremnosti datetime
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_vrijeme_dostave')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_vrijeme_dostave datetime
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_status')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_status nvarchar(15)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MJESTA_IZDAVANJA' AND COLUMN_NAME = 'mi_vezano')
ALTER TABLE [dbo].[MJESTA_IZDAVANJA] ADD mi_vezano bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MJESTA_IZDAVANJA' AND COLUMN_NAME = 'mi_vezano_ispis')
ALTER TABLE [dbo].[MJESTA_IZDAVANJA] ADD mi_vezano_ispis bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_prat_dok_id_fk')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_prat_dok_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_naruceno')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_naruceno bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_ns_id_pk')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_ns_id_pk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_napomena')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_napomena nvarchar(30) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_vrijeme_izdavanja')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_vrijeme_izdavanja datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_vrijeme_prihvacanja')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_vrijeme_prihvacanja datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_vrijeme_spremnosti')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_vrijeme_spremnosti datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_vrijeme_dostave')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_vrijeme_dostave datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_slijed_name')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_slijed_name nvarchar(30) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_slijed_oznaka')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_slijed_oznaka nvarchar(1) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_slijed_priority')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_slijed_priority int NULL
GO	
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_nar_status')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_nar_status nvarchar(15) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_pdv_id_fk')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_pdv_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_pnp_id_fk')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] ADD wkss_pnp_id_fk int NULL
GO


------------------------------------------------
------------------------------------------------
--------  NARUDZBE ZAGLAVLJE - STAVKE
------------------------------------------------
------------------------------------------------
---- DROP CONSTRAITS
GO
	IF (OBJECT_ID('dbo.FK_NARUDZBE_ZAGLAVLJE_MJESTA_IZDAVANJA', 'F') IS NOT NULL)
	BEGIN
	    ALTER TABLE dbo.NARUDZBE_ZAGLAVLJE DROP CONSTRAINT FK_NARUDZBE_ZAGLAVLJE_MJESTA_IZDAVANJA
	END
GO

---- DROP COLUMNS
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_ZAGLAVLJE' AND COLUMN_NAME = 'nz_mi_id_fk')
ALTER TABLE [dbo].[NARUDZBE_ZAGLAVLJE] DROP COLUMN nz_mi_id_fk
GO
---- ADD COLUMNS
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBE_STAVKE' AND COLUMN_NAME = 'ns_mi_id_fk')
ALTER TABLE [dbo].[NARUDZBE_STAVKE] ADD ns_mi_id_fk int NULL
GO
---- ADD CONSTRAINT
GO
IF (OBJECT_ID('dbo.FK_NARUDZBE_STAVKE_MJESTA_IZDAVANJA', 'F') IS NULL)
BEGIN
ALTER TABLE [dbo].[NARUDZBE_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_NARUDZBE_STAVKE_MJESTA_IZDAVANJA] FOREIGN KEY([ns_mi_id_fk])
REFERENCES [dbo].[MJESTA_IZDAVANJA] ([mi_id_pk])
ALTER TABLE [dbo].[NARUDZBE_STAVKE] CHECK CONSTRAINT [FK_NARUDZBE_STAVKE_MJESTA_IZDAVANJA]
END
GO




------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  D R O P        C O L U M N S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  RACUNI_ZAGLAVLJE.rz_datum_opomene
--------  RACUNI_ZAGLAVLJE.rz_datum_uplate
--------  RACUNI_ZAGLAVLJE.rz_iznos_uplate
--------  PRIMKE_ZAGLAVLJE.pr_datum_placanja
--------  PRIMKE_ZAGLAVLJE.pr_iznos_placanja
--------  PRIMKE_ZAGLAVLJE.pr_knjiga_ul_racuna
--------  TISKACI.ts_chnr2_normal_left
--------  TISKACI.ts_chnr2_normal_right
--------  TISKACI.ts_chnr3_normal_col1
--------  TISKACI.ts_chnr3_normal_col2
--------  TISKACI.ts_chnr3_normal_col3
--------  TISKACI.ts_chnr4_normal_col1
--------  TISKACI.ts_chnr4_normal_col2
--------  TISKACI.ts_chnr4_normal_col3
--------  TISKACI.ts_chnr4_normal_col4
--------  TISKACI.ts_chnr2_bold_1_left
--------  TISKACI.ts_chnr2_bold_1_right
--------  TISKACI.ts_chnr2_bold_2_left
--------  TISKACI.ts_chnr2_bold_2_right
--------  INVENTURA_STAVKE.ins_sir_pov_nak
--------  ACTIVITY_LOG.ac_konobar_id_fk
--------  MJESTA_IZDAVANJA.mi_linked
--------  MJESTA_IZDAVANJA.mi_print_otker_linked
--------  TVRTKE.tv_tel_2
--------  TVRTKE.tv_fax
--------  TVRTKE.tv_kontakt_osoba_mob
--------  TVRTKE.tv_ziro_racun
--------  TVRTKE.tv_tel_1
--------  RACUNI_STAVKE.rs_menu_id
--------  RACUNI_ZAGLAVLJE.rz_provizija_kartice
--------  RACUNI_ZAGLAVLJE.rz_broj_kartice
--------  RACUNI_ZAGLAVLJE.rz_korisnik_kartice
--------  OTVORENI_RACUNI_STAVKE.wkss_ordered
--------  OTVORENI_RACUNI_STAVKE.wkss_slijed_priority
--------  OTVORENI_RACUNI_STAVKE.wkss_slijed_name
--------  OTVORENI_RACUNI_STAVKE.wkss_slijed_oznaka
--------  OTVORENI_RACUNI_STAVKE.wkss_dostava
--------  OTVORENI_RACUNI_STAVKE.wkss_narudzba_napomena
--------  OTVORENI_RACUNI_STAVKE.ar_pdv_fk
--------  OTVORENI_RACUNI_STAVKE.ar_pnp_fk


GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_datum_opomene')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_datum_opomene
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_datum_uplate')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_datum_uplate
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_iznos_uplate')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_iznos_uplate
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_datum_placanja')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN pr_datum_placanja
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_iznos_placanja')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN pr_iznos_placanja
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_knjiga_ul_racuna')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN pr_knjiga_ul_racuna
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_normal_left')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_normal_left
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_normal_right')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_normal_right
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr3_normal_col1')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr3_normal_col1
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr3_normal_col2')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr3_normal_col2
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr3_normal_col3')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr3_normal_col3
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col1')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col1
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col2')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col2
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col3')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col3
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col4')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col4
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_1_left')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_1_left
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_1_right')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_1_right
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_2_left')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_2_left
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_2_right')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_2_right
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'ins_sir_pov_nak')
ALTER TABLE [dbo].[INVENTURA_STAVKE] DROP COLUMN ins_sir_pov_nak
GO
	IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ACTIVITY_LOG_KONOBARI]') AND parent_object_id = OBJECT_ID(N'[dbo].[ACTIVITY_LOG]'))
	BEGIN
	DELETE FROM ACTIVITY_LOG
	ALTER TABLE [dbo].[ACTIVITY_LOG] DROP CONSTRAINT [FK_ACTIVITY_LOG_KONOBARI]
	END
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ACTIVITY_LOG' AND COLUMN_NAME = 'ac_konobar_id_fk')
ALTER TABLE [dbo].[ACTIVITY_LOG] DROP COLUMN ac_konobar_id_fk
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MJESTA_IZDAVANJA' AND COLUMN_NAME = 'mi_linked')
ALTER TABLE [dbo].[MJESTA_IZDAVANJA] DROP COLUMN mi_linked
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MJESTA_IZDAVANJA' AND COLUMN_NAME = 'mi_print_otker_linked')
ALTER TABLE [dbo].[MJESTA_IZDAVANJA] DROP COLUMN mi_print_otker_linked
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_tel_2')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_tel_2
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_fax')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_fax
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_kontakt_osoba_mob')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_kontakt_osoba_mob
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_ziro_racun')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_ziro_racun
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_tel_1')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_tel_1
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_STAVKE' AND COLUMN_NAME = 'rs_menu_id')
ALTER TABLE [dbo].[RACUNI_STAVKE] DROP COLUMN rs_menu_id
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_provizija_kartice')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_provizija_kartice
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_broj_kartice')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_broj_kartice
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_korisnik_kartice')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_korisnik_kartice
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_ordered')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN wkss_ordered
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_slijed_priority')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN wkss_slijed_priority
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_slijed_name')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN wkss_slijed_name
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_slijed_oznaka')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN wkss_slijed_oznaka
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_dostava')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN wkss_dostava
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'wkss_narudzba_napomena')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN wkss_narudzba_napomena
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'ar_pdv_fk')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN ar_pdv_fk
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OTVORENI_RACUNI_STAVKE' AND COLUMN_NAME = 'ar_pnp_fk')
ALTER TABLE [dbo].[OTVORENI_RACUNI_STAVKE] DROP COLUMN ar_pnp_fk
GO
 


------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  D R O P       C O N S T R A I N T S
--------  ZBOG ALTER COLUMNS AKCIJA
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARTIKLI]') AND name = N'UQ_ARTIKLI_ar_naziv')
	ALTER TABLE [dbo].[ARTIKLI] DROP CONSTRAINT [UQ_ARTIKLI_ar_naziv]
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TVRTKE]') AND name = N'UQ_TVRTKE_tv_ime')
	ALTER TABLE [dbo].[TVRTKE] DROP CONSTRAINT [UQ_TVRTKE_tv_ime]
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DOBAVLJACI]') AND name = N'UQ_DOBAVLJACI_do_name')
	ALTER TABLE [dbo].[DOBAVLJACI] DROP CONSTRAINT [UQ_DOBAVLJACI_do_name]
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SIROVINE]') AND name = N'UQ_SIROVINE_si_sifra')
	ALTER TABLE [dbo].[SIROVINE] DROP CONSTRAINT [UQ_SIROVINE_si_sifra]
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  A L T E R        C O L U M N S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
ALTER TABLE [dbo].RACUNI_ZAGLAVLJE ALTER column rz_napomena nvarchar(200)
GO
ALTER TABLE [dbo].ARTIKLI ALTER column ar_pdv_fk int NOT NULL 
GO
	UPDATE SIROVINE SET si_sifra = si_id_pk WHERE si_sifra IS NULL
GO
ALTER TABLE [dbo].PRIMKE_STAVKE ALTER column ps_si_cijena_osnovna_netto decimal(16,4) NULL 
GO
ALTER TABLE [dbo].SIROVINE ALTER column si_ime nvarchar(50)
GO
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  C O N S T R A I N T S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
	ALTER TABLE [dbo].[ARTIKLI] ADD CONSTRAINT [UQ_ARTIKLI_ar_naziv] UNIQUE NONCLUSTERED 
	([ar_naziv] ASC)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO
	ALTER TABLE [dbo].[TVRTKE] ADD  CONSTRAINT [UQ_TVRTKE_tv_ime] UNIQUE NONCLUSTERED 
	([tv_ime] ASC) WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO
	ALTER TABLE [dbo].[DOBAVLJACI] ADD  CONSTRAINT [UQ_DOBAVLJACI_do_name] UNIQUE NONCLUSTERED 
	([do_name] ASC)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO
	IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_GRUPE_ARTIKALA_SYS_ARTIKLI_KATEGORIJE]') AND parent_object_id = OBJECT_ID(N'[dbo].[GRUPE_ARTIKALA]'))
	BEGIN
		ALTER TABLE [dbo].[GRUPE_ARTIKALA]  WITH CHECK ADD  CONSTRAINT [FK_GRUPE_ARTIKALA_SYS_ARTIKLI_KATEGORIJE] FOREIGN KEY([ga_syak_id_fk])
		REFERENCES [dbo].[SYS_ARTIKLI_KATEGORIJE] ([syak_id_pk])
		ALTER TABLE [dbo].[GRUPE_ARTIKALA] CHECK CONSTRAINT [FK_GRUPE_ARTIKALA_SYS_ARTIKLI_KATEGORIJE]
	END
GO
	IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_GRUPE_SIROVINA_SYS_SIROVINE_KATEGORIJE]') AND parent_object_id = OBJECT_ID(N'[dbo].[GRUPE_SIROVINA]'))
	BEGIN
	ALTER TABLE [dbo].[GRUPE_SIROVINA]  WITH CHECK ADD  CONSTRAINT [FK_GRUPE_SIROVINA_SYS_SIROVINE_KATEGORIJE] FOREIGN KEY([gs_sysk_id_fk])
	REFERENCES [dbo].[SYS_SIROVINE_KATEGORIJE] ([sysk_id_pk])
	ALTER TABLE [dbo].[GRUPE_SIROVINA] CHECK CONSTRAINT [FK_GRUPE_SIROVINA_SYS_SIROVINE_KATEGORIJE]
	END
GO
	ALTER TABLE [dbo].[SIROVINE] ADD CONSTRAINT [UQ_SIROVINE_si_sifra] UNIQUE NONCLUSTERED 
	([si_sifra] ASC )WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'UQ_ARTIKLI_ar_barcode')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX UQ_ARTIKLI_ar_barcode ON ARTIKLI(ar_barcode) WHERE ar_barcode IS NOT NULL
	END
GO
IF (OBJECT_ID('dbo.FK_SIROVINE_GRUPE_PDV', 'F') IS NULL)
	BEGIN
	ALTER TABLE [dbo].[SIROVINE]  WITH CHECK ADD  CONSTRAINT [FK_SIROVINE_GRUPE_PDV] FOREIGN KEY([si_pdv_id_fk])
	REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk])
	ALTER TABLE [dbo].[SIROVINE] CHECK CONSTRAINT [FK_SIROVINE_GRUPE_PDV]
	END
GO

------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  U P D A T E    F I E L D S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
UPDATE SIROVINE SET si_active = 1 WHERE si_active IS NULL
GO
UPDATE SIROVINE SET si_povratna_naknada = 0 WHERE si_povratna_naknada is null
GO
UPDATE PRIMKE_ZAGLAVLJE SET pr_povratna_naknada = 0 WHERE pr_povratna_naknada is null
GO
UPDATE PRIMKE_STAVKE SET ps_tot_povratna_naknada = 0 WHERE ps_tot_povratna_naknada is null
GO
UPDATE IZDATNICE_STAVKE SET is_tot_pov_nak = 0 WHERE is_tot_pov_nak is null
GO
UPDATE OTPISI_STAVKE SET os_tot_pov_nak = 0 WHERE os_tot_pov_nak is null
GO
UPDATE sirovine SET si_kalo = 0 WHERE si_kalo is null
GO
UPDATE ARTIKLI SET ar_index = 1 WHERE ar_index is null
GO
UPDATE GRUPE_TOUCH_SCREEN_ARTIKLI SET gt_ar_order = ar_id_fk WHERE gt_ar_order is null
GO
DELETE FROM NACINI_PLACANJA WHERE np_category_fk = 6 -- CEKOVI
GO
DELETE FROM SYS_PLACANJA WHERE sypl_id_pk = 6 -- CEKOVI
GO
DELETE FROM SYS_PLACANJA WHERE sypl_id_pk = 4 -- STORNO
GO




------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  UPDATE VERSION
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
UPDATE SYS_VERSION set syvs_nr_1 = 0
GO
UPDATE SYS_VERSION set syvs_nr_2 = 0
GO
UPDATE SYS_VERSION set syvs_nr_3 = 0
GO
