SET NOCOUNT ON
GO

--
-- Definition for table SYS_VERSION : 
--

CREATE TABLE [dbo].[SYS_VERSION] (
  [syvs_nr_1] int NULL,
  [syvs_nr_2] int NULL,
  [syvs_nr_3] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_PRINTERI : 
--

CREATE TABLE [dbo].[SYS_PRINTERI] (
  [sypr_id_pk] int NULL,
  [sypr_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [sypr_N] int NULL,
  [sypr_B1] int NULL,
  [sypr_B2] int NULL,
  [sypr_cntr_text_normal] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_text_bold_1] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_text_bold_2] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_ladica] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [sypr_cntr_rezac] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_JMJ : 
--

CREATE TABLE [dbo].[SYS_JMJ] (
  [sy_jmj_name] nvarchar(10) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table START_LOG : 
--

CREATE TABLE [dbo].[START_LOG] (
  [sp_id_pk] int IDENTITY(1, 1) NOT NULL,
  [sp_ks_id_fk] int NULL,
  [sp_nadnevak] datetime NULL,
  [sp_start] datetime NULL
)
ON [PRIMARY]
GO

--
-- Definition for table RACUNI_STAVKE : 
--

CREATE TABLE [dbo].[RACUNI_STAVKE] (
  [rs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [rs_racun_id_fk] int NULL,
  [rs_artikal_id_fk] int NULL,
  [rs_gpdv_id_fk] int NULL,
  [rs_popust] decimal(12, 3) NULL,
  [rs_cijena_bez_popusta] decimal(12, 2) NULL,
  [rs_cijena] decimal(12, 2) NULL,
  [rs_pov_naknada] decimal(10, 2) NULL,
  [rs_kolicina] decimal(12, 3) NOT NULL,
  [rs_pdv] decimal(12, 2) NULL,
  [rs_tot_pov_naknada] decimal(10, 2) NULL,
  [rs_iznos_bez_popusta] decimal(12, 2) NULL,
  [rs_iznos] decimal(12, 2) NULL,
  [rs_description] nvarchar(200) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table RACUNI_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[RACUNI_ZAGLAVLJE] (
  [rz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [rz_broj] int NULL,
  [rz_broj_full] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_vrijeme] datetime NULL,
  [rz_dan] datetime NULL,
  [rz_djelatnik_id_fk] int NULL,
  [rz_kasa_id_fk] int NULL,
  [rz_tvrtka_id_fk] int NULL,
  [rz_narucitelj_id_fk] int NULL,
  [rz_placanje_id_fk] int NULL,
  [rz_pl_1_id_fk] int NULL,
  [rz_pl_2_id_fk] int NULL,
  [rz_pl_3_id_fk] int NULL,
  [rz_prat_dok_id_fk] int NULL,
  [rz_popust] decimal(12, 2) NULL, 
  [rz_pdv] decimal(12, 2) NULL,
  [rz_tot_pov_naknada] decimal(10, 2) NULL,
  [rz_iznos_bez_popusta] decimal(12, 2) NULL,
  [rz_iznos] decimal(12, 2) NULL,
  [rz_pl_1_iznos] decimal(12, 2) NULL,
  [rz_pl_2_iznos] decimal(12, 2) NULL,
  [rz_pl_3_iznos] decimal(12, 2) NULL,
  [rz_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [rz_nadnevak_isporuke] datetime NULL,
  [rz_datum_dospijeca] datetime NULL,
  [rz_iznos_uplate] decimal(12, 2) NULL,
  [rz_fis_racun_source_id] int NULL,
  [rz_fis_vrijeme_slanja] datetime NULL,
  [rz_fis_vrijeme_obrade] datetime NULL,
  [rz_fis_uuid] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_zastitni_kod] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [rz_fis_jir] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_paragon_broj] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_ozn_pos_pros] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_ozn_nap_uredaja] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_naknadna_dostava] bit NULL,
  [rz_fis_storno_sign] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [rz_fis_np] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [rz_fis_nap_uuid] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [rz_fis_nap_vrijeme_slanja] datetime NULL,
  [rz_fis_nap_vrijeme_obrade] datetime NULL,
  [rz_fis_nap_iznos] decimal(12, 2) NULL,
  [rz_fis_nap_pl_id_fk] int NULL,
  [rz_fis_nap_np] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [rz_fis_nap_fiskalizirano] bit NULL,
  [rz_fis_nap_naknadna_dostava] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PROMJENA_CIJENE_STAVKE : 
--

CREATE TABLE [dbo].[PROMJENA_CIJENE_STAVKE] (
  [pcs_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pcs_pcz_id_fk] int NULL,
  [pcs_ar_id_fk] int NULL,
  [pcs_ar_old_pdv_id] int NULL,
  [pcs_ar_new_pdv_id] int NULL,
  [pcs_ar_kolicina_skladiste] decimal(12, 3) NULL,
  [pcs_ar_old_price_vpc] decimal(12, 2) NULL,
  [pcs_ar_old_price_mpc] decimal(12, 2) NULL,
  [pcs_ar_new_price_vpc] decimal(12, 2) NULL,
  [pcs_ar_new_price_mpc] decimal(12, 2) NULL,
  [pcs_ar_zaduzenje_vpc] decimal(12, 2) NULL,
  [pcs_ar_zaduzenje_pdv] decimal(12, 2) NULL,
  [pcs_ar_zaduzenje_mpc] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PROMJENA_CIJENE_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[PROMJENA_CIJENE_ZAGLAVLJE] (
  [pcz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pcz_pr_id_fk] int NULL,
  [pcz_broj] int NULL,
  [pcz_nadnevak] datetime NULL,
  [pcz_description] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [pcz_zaduzenje_vpc] decimal(12, 2) NULL,
  [pcz_zaduzenje_pdv] decimal(12, 2) NULL,
  [pcz_zaduzenje_mpc] decimal(12, 2) NULL,
  [pcz_proknjizeno] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PRIMKE_STAVKE : 
--

CREATE TABLE [dbo].[PRIMKE_STAVKE] (
  [ps_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ps_pr_id_fk] int NULL,
  [ps_ar_id_fk] int NULL,
  [ps_ar_pdv_id_fk] int NULL,
  [ps_old_pdv_id_fk] int NULL,
  [ps_calc_pdv_id_fk] int NULL,
  [ps_ar_kolicina] decimal(12, 4) NULL,
  [ps_ar_cijena_vpc_osn] decimal(12, 4) NULL,
  [ps_ar_zavisni_trosak_vpc] decimal(12, 2) NULL,
  [ps_ar_rabat] decimal(12, 2) NULL,
  [ps_ar_cijena_vpc] decimal(12, 4) NULL,
  [ps_ar_cijena_mpc] decimal(12, 4) NULL,
  [ps_pov_naknada] decimal(10, 2) NULL,
  [ps_old_vpc] decimal(12, 2) NULL,
  [ps_old_mpc] decimal(12, 2) NULL,
  [ps_calc_marza_JMJ] decimal(12, 2) NULL,
  [ps_calc_marza_percent] decimal(12, 2) NULL,
  [ps_calc_marza_ukupno] decimal(12, 2) NULL,
  [ps_calc_vpc] decimal(12, 2) NULL,
  [ps_calc_mpc] decimal(12, 2) NULL,
  [ps_tot_pov_naknada] decimal(10, 2) NULL,
  [ps_tot_osnovica] decimal(12, 2) NULL,
  [ps_tot_pdv] decimal(12, 2) NULL,
  [ps_tot_ukupno] decimal(12, 2) NULL,
  [ps_zaduzenje_vpc] decimal(12, 2) NULL,
  [ps_zaduzenje_pdv] decimal(12, 2) NULL,
  [ps_zaduzenje_mpc] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PRIMKE_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[PRIMKE_ZAGLAVLJE] (
  [pr_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pr_pcz_id_fk] int NULL,
  [pr_dobavljac_id_fk] int NULL,
  [pr_storno_id_fk] int NULL,
  [pr_sys_broj] int NULL,
  [pr_broj] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [pr_datum] datetime NULL,
  [pr_datum_knjizenja] datetime NULL,
  [pr_datum_dospijeca] datetime NULL,
  [pr_storno_sign] int NULL,
  [pr_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [pr_ukupno_marza] decimal(12, 2) NULL,
  [pr_osnovica] decimal(12, 2) NULL,
  [pr_pdv] decimal(12, 2) NULL,
  [pr_ukupno] decimal(12, 2) NULL,
  [pr_zaduzenje_vpc] decimal(12, 2) NULL,
  [pr_zaduzenje_pdv] decimal(12, 2) NULL,
  [pr_zaduzenje_mpc] decimal(12, 2) NULL,
  [pr_zaduzenje_pov_naknada] decimal(10, 2) NULL,
  [pr_status] bit NULL,
  [pr_proknjizeno] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PONUDA_STAVKE : 
--

CREATE TABLE [dbo].[PONUDA_STAVKE] (
  [pns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pns_ponuda_id_fk] int NULL,
  [pns_artikal_id_fk] int NULL,
  [pns_gpdv_id_fk] int NULL,
  [pns_popust] decimal(12, 3) NULL,
  [pns_pov_nak] decimal(12, 2) NULL,
  [pns_cijena_bez_popusta] decimal(12, 2) NULL,
  [pns_cijena] decimal(12, 2) NULL,
  [pns_kolicina] decimal(12, 2) NULL,
  [pns_tot_pov_nak] decimal(12, 2) NULL,
  [pns_pdv] decimal(12, 2) NULL,
  [pns_iznos_bez_popusta] decimal(12, 2) NULL,
  [pns_iznos] decimal(12, 2) NULL,
  [pns_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table PONUDA_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[PONUDA_ZAGLAVLJE] (
  [pnz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [pnz_dj_id_fk] int NULL,
  [pnz_tv_id_fk] int NULL,
  [pnz_na_id_fk] int NULL,
  [pnz_broj] int NULL,
  [pnz_nadnevak] datetime NULL,
  [pnz_napomena] nvarchar(200) COLLATE Croatian_CI_AS NULL,
  [pnz_status] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table POCETNO_STANJE : 
--

CREATE TABLE [dbo].[POCETNO_STANJE] (
  [ps_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ps_ar_id_fk] int NULL,
  [ps_pdv_id_fk] int NULL,
  [ps_vpc_nabavna] decimal(12, 2) NULL,
  [ps_nabava_ukupno_pdv] decimal(12, 2) NULL,
  [ps_nabava_ukupno_vpc] decimal(12, 2) NULL,
  [ps_pov_naknada] decimal(10, 2) NULL,
  [ps_vpc] decimal(12, 2) NULL,
  [ps_mpc] decimal(12, 2) NULL,
  [ps_kolicina] decimal(12, 3) NULL,
  [ps_uk_pov_naknada] decimal(10, 2) NULL,
  [ps_zaduzenje_vpc] decimal(12, 2) NULL,
  [ps_zaduzenje_pdv] decimal(12, 2) NULL,
  [ps_zaduzenje_mpc] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBENICA_STAVKE : 
--

CREATE TABLE [dbo].[NARUDZBENICA_STAVKE] (
  [ns_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ns_nz_id_fk] int NULL,
  [ns_artikal_id_fk] int NULL,
  [ns_kolicina] decimal(12, 3) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUDZBENICA_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[NARUDZBENICA_ZAGLAVLJE] (
  [nz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [nz_dj_id_fk] int NULL,
  [nz_broj] int NULL,
  [nz_nadnevak] datetime NULL,
  [nz_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [nz_flag] bit NULL,
  [nz_proknjizeno] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NARUCITELJI : 
--

CREATE TABLE [dbo].[NARUCITELJI] (
  [na_id_pk] int IDENTITY(1, 1) NOT NULL,
  [na_tvrtka_fk] int NULL,
  [na_ime] nvarchar(25) COLLATE Croatian_CI_AS NOT NULL,
  [na_oib] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_kucna_adresa] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [na_mjesto] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [na_djelatno_mjesto] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [na_tel] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_tel_u_tvrtci] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_mob] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [na_biljeska] nvarchar(40) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table TVRTKE : 
--

CREATE TABLE [dbo].[TVRTKE] (
  [tv_id_pk] int IDENTITY(1, 1) NOT NULL,
  [tv_sifra] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [tv_ime] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [tv_adresa] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_adresa_broj] nvarchar(10) COLLATE Croatian_CI_AS NULL,
  [tv_mjesto] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_mjesto_postanski_broj] int NULL,
  [tv_state] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_maticni_broj] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [tv_oib] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [tv_porezni_broj] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_iban] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [tv_tel] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [tv_email] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [tv_kontakt_osoba] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [tv_odgoda_placanja] int NULL,
  [tv_stop_tvrtka] bit NULL,
  [tv_note] nvarchar(40) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table NACINI_PLACANJA : 
--

CREATE TABLE [dbo].[NACINI_PLACANJA] (
  [np_id_pk] int IDENTITY(1, 1) NOT NULL,
  [np_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [np_category_fk] int NOT NULL,
  [np_kar_provizija] decimal(6, 2) NULL,
  [np_sort] int NULL,
  [np_index] int NULL,
  [np_active] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_PLACANJA : 
--

CREATE TABLE [dbo].[SYS_PLACANJA] (
  [sypl_id_pk] int NOT NULL,
  [sypl_name_short] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [sypl_name_long] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [sypl_sort] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table KASE : 
--

CREATE TABLE [dbo].[KASE] (
  [ks_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ks_name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ks_description] nvarchar(50) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table IZDATNICE_STAVKE : 
--

CREATE TABLE [dbo].[IZDATNICE_STAVKE] (
  [is_id_pk] int IDENTITY(1, 1) NOT NULL,
  [is_iz_id_fk] int NOT NULL,
  [is_ar_id_fk] int NULL,
  [is_pdv_id_fk] int NULL,
  [is_pros_nab_vpc] decimal(12, 2) NULL,
  [is_pov_naknada] decimal(10, 2) NULL,
  [is_vpc] decimal(12, 2) NULL,
  [is_mpc] decimal(12, 2) NULL,
  [is_kolicina] decimal(12, 3) NOT NULL,
  [is_tot_pros_nab_vpc] decimal(12, 2) NULL,
  [is_tot_pov_naknada] decimal(10, 2) NULL,
  [is_tot_osnovica] decimal(12, 2) NULL,
  [is_tot_pdv] decimal(12, 2) NULL,
  [is_tot_ukupno] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table IZDATNICE_ZAGLAVLJE : 
--

CREATE TABLE [dbo].[IZDATNICE_ZAGLAVLJE] (
  [iz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [iz_mo_id_fk] int NULL,
  [iz_broj] int NULL,
  [iz_datum] datetime NULL,
  [iz_tot_pros_nab_vpc] decimal(12, 2) NULL,
  [iz_tot_pov_naknada] decimal(10, 2) NULL,
  [iz_vpc] decimal(12, 2) NULL,
  [iz_pdv] decimal(12, 2) NULL,
  [iz_mpc] decimal(12, 2) NULL,
  [iz_opis] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [iz_napomena] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [iz_proknjizeno] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table MJESTA_OTPREME : 
--

CREATE TABLE [dbo].[MJESTA_OTPREME] (
  [mo_id_pk] int IDENTITY(1, 1) NOT NULL,
  [mo_oznaka] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [mo_note] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table INVENTURA_STAVKE : 
--

CREATE TABLE [dbo].[INVENTURA_STAVKE] (
  [is_id_pk] int IDENTITY(1, 1) NOT NULL,
  [is_iz_id_fk] int NULL,
  [is_ar_id_fk] int NULL,
  [is_pdv_id_fk] int NULL,
  [is_pros_nab_vpc] decimal(12, 2) NULL,
  [is_pov_naknada] decimal(10, 2) NULL,
  [is_vpc] decimal(12, 2) NULL,
  [is_mpc] decimal(12, 2) NULL,
  [is_kol_blagajna] decimal(12, 3) NULL,
  [is_kol_zatecena] decimal(12, 3) NULL,
  [is_kol_razlika] decimal(12, 3) NULL,
  [is_tot_pros_nab_vpc] decimal(12, 2) NULL,
  [is_tot_pov_naknada] decimal(10, 2) NULL,
  [is_tot_osnovica] decimal(12, 2) NULL,
  [is_tot_pdv] decimal(12, 2) NULL,
  [is_tot_ukupno] decimal(12, 2) NULL,
  [is_zat_tot_pros_nab_vpc] decimal(12, 2) NULL,
  [is_zat_pov_naknada] decimal(12, 2) NULL,
  [is_zat_osnovica] decimal(12, 2) NULL,
  [is_zat_pdv] decimal(12, 2) NULL,
  [is_zat_ukupno] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table INVENTURA_ZAGLAVLJE : 
--
CREATE TABLE [dbo].[INVENTURA_ZAGLAVLJE] (
  [iz_id_pk] int IDENTITY(1, 1) NOT NULL,
  [iz_broj] int NULL,
  [iz_datetime] datetime NULL,
  [iz_vpc] decimal(12, 2) NULL,
  [iz_pdv] decimal(12, 2) NULL,
  [iz_mpc] decimal(12, 2) NULL,
  [iz_tot_pros_nab_vpc] decimal(12, 2) NULL,
  [iz_tot_pov_naknada] decimal(10, 2) NULL,
  [iz_zat_tot_pros_nab_vpc] decimal(12, 2) NULL,
  [iz_zat_pov_naknada] decimal(12, 2) NULL,
  [iz_zat_vpc] decimal(12, 2) NULL,
  [iz_zat_pdv] decimal(12, 2) NULL,
  [iz_zat_mpc] decimal(12, 2) NULL,
  [iz_napomena] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [iz_proknjizeno] bit NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_TOUCH_SCREEN_ARTIKLI : 
--

CREATE TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI] (
  [ar_id_fk] int NOT NULL,
  [gt_id_fk] int NOT NULL,
  [gt_ar_order] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_TOUCH_SCREEN : 
--

CREATE TABLE [dbo].[GRUPE_TOUCH_SCREEN] (
  [gt_id_pk] int IDENTITY(1, 1) NOT NULL,
  [gt_name] nvarchar(30) COLLATE Croatian_CI_AS NOT NULL,
  [gt_active] bit NOT NULL,
  [gt_order_index] int NULL,
  [gt_color_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table EXTERNAL_DATABASES : 
--

CREATE TABLE [dbo].[EXTERNAL_DATABASES] (
  [ext_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ext_name] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ext_description] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [ext_db_host] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ext_db_name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_db_user] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_db_password] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [ext_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table DNEVNI_POLOG : 
--

CREATE TABLE [dbo].[DNEVNI_POLOG] (
  [dp_id_pk] int IDENTITY(1, 1) NOT NULL,
  [dp_vrijeme] datetime NULL,
  [dp_iznos] decimal(12, 2) NULL
)
ON [PRIMARY]
GO

--
-- Definition for table DJELATNICI : 
--

CREATE TABLE [dbo].[DJELATNICI] (
  [dj_id_pk] int IDENTITY(1, 1) NOT NULL,
  [dj_oznaka] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [dj_sifra] nvarchar(10) COLLATE Croatian_CI_AS NOT NULL,
  [dj_barcode] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [dj_name] nvarchar(30) COLLATE Croatian_CI_AS NOT NULL,
  [dj_adresa] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [dj_mjesto] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [dj_oib] nvarchar(20) COLLATE Croatian_CI_AS NULL,
  [dj_tel] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [dj_mob] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [dj_note] nvarchar(40) COLLATE Croatian_CI_AS NULL,
  [dj_status] nvarchar(1) COLLATE Croatian_CI_AS NULL,
  [dj_work_start] datetime NULL,
  [dj_work_end] datetime NULL,
  [dj_active] bit NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table ARTIKLI : 
--

CREATE TABLE [dbo].[ARTIKLI] (
  [ar_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ar_sifra] nvarchar(15) COLLATE Croatian_CI_AS NOT NULL,
  [ar_barcode] nvarchar(30) COLLATE Croatian_CI_AS NULL,
  [ar_naziv] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [ar_jmj] nvarchar(5) COLLATE Croatian_CI_AS NULL,
  [ar_kat_id_fk] int NULL,
  [ar_grupa_fk] int NULL,
  [ar_pdv_fk] int NOT NULL,
  [ar_cijena_vpc] decimal(10, 2) NULL,
  [ar_cijena_mpc_1] decimal(10, 2) NOT NULL,
  [ar_cijena_mpc_2] decimal(10, 2) NULL,
  [ar_cijena_mpc_3] decimal(10, 2) NULL,
  [ar_povratna_naknada] decimal(10, 2) NULL,
  [ar_min_kol] decimal(10, 2) NULL,
  [ar_description] nvarchar(100) COLLATE Croatian_CI_AS NULL,
  [ar_color_index] int NULL,
  [ar_size_index] int NULL,
  [ar_is_active] bit NULL,
  [ar_kalo] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table SYS_ARTIKAL_KATEGORIJA : 
--

CREATE TABLE [dbo].[SYS_ARTIKAL_KATEGORIJA] (
  [syak_id_pk] int NOT NULL,
  [syak_name] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_PDV : 
--

CREATE TABLE [dbo].[GRUPE_PDV] (
  [gpdv_id_pk] int IDENTITY(1, 1) NOT NULL,
  [gpdv_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [gpdv_postotak] decimal(6, 2) NOT NULL
)
ON [PRIMARY]
GO

--
-- Definition for table GRUPE_ARTIKALA : 
--

CREATE TABLE [dbo].[GRUPE_ARTIKALA] (
  [ga_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ga_name] nvarchar(20) COLLATE Croatian_CI_AS NOT NULL,
  [ga_order_index] int NULL
)
ON [PRIMARY]
GO

--
-- Definition for table DOBAVLJACI : 
--

CREATE TABLE [dbo].[DOBAVLJACI] (
  [do_id_pk] int IDENTITY(1, 1) NOT NULL,
  [do_name] nvarchar(50) COLLATE Croatian_CI_AS NOT NULL,
  [do_adresa] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [do_mjesto] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [do_maticni_broj] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_oib] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_ziro_racun] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_tel] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [do_fax] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [do_kontakt_osoba] nvarchar(25) COLLATE Croatian_CI_AS NULL,
  [do_kontakt_osoba_mob] nvarchar(15) COLLATE Croatian_CI_AS NULL,
  [do_biljeska] nvarchar(40) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table ADMINISTRATORS : 
--

CREATE TABLE [dbo].[ADMINISTRATORS] (
  [adm_id_pk] int IDENTITY(1, 1) NOT NULL,
  [adm_name] nvarchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
  [adm_password] int NULL,
  [adm_rf_id] nvarchar(25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
ON [PRIMARY]
GO

--
-- Definition for table ACTIVITY_LOG : 
--
CREATE TABLE [dbo].[ACTIVITY_LOG] (
  [ac_id_pk] int IDENTITY(1, 1) NOT NULL,
  [ac_korisnik] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ac_time] datetime NULL,
  [ac_action] nvarchar(50) COLLATE Croatian_CI_AS NULL,
  [ac_description] nvarchar(100) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO


--
-- Definition for table x_cust_KART_PLACANJE_M2PAY : 
--
CREATE TABLE [dbo].[x_cust_KART_PLACANJE_M2PAY] (
    [m2pay_id_pk] int IDENTITY(1, 1) NOT NULL,
    [m2pay_rz_id_fk] int NULL,
    [m2pay_vrijeme] datetime NULL,
    [m2pay_Var_transactionResultId] nvarchar(30) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_RESULT_transactionID] nvarchar(40) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_RESULT_FinStatus] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_merchantName] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_merchantAddress] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Time] datetime NULL,
    [m2pay_Var_PRINT_STATUS] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Transaction_Type] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Iznos] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_Tip] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_Ukupno] decimal(10, 2) NULL,
    [m2pay_Var_PRINT_ID_Terminala] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_Trgovca] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_KARTICA_Name] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ID_KARTICA_ID] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Nacin_Unosa] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Provjere] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Vrsta_Kartice] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_Broj_Odobrenja] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_GUID] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_GUID_STORNO_PRODAJE] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_RRN] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_AID] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_TVR] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_IAD] nvarchar(50) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_TSI] nvarchar(20) COLLATE Croatian_CI_AS NULL,
    [m2pay_Var_PRINT_ARC] nvarchar(20) COLLATE Croatian_CI_AS NULL
)
ON [PRIMARY]
GO



--
-- Definition for indices : 
--

ALTER TABLE [dbo].[ACTIVITY_LOG]
ADD CONSTRAINT [PK_ACTIVITY_LOG] 
PRIMARY KEY CLUSTERED ([ac_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ADMINISTRATORS]
ADD CONSTRAINT [PK_SYS_ADMINISTRATOR] 
PRIMARY KEY CLUSTERED ([adm_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ADMINISTRATORS]
ADD CONSTRAINT [UQ_SYS_ADMINISTRATOR_adm_name] 
UNIQUE NONCLUSTERED ([adm_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ADMINISTRATORS]
ADD CONSTRAINT [UQ_SYS_ADMINISTRATOR_adm_password] 
UNIQUE NONCLUSTERED ([adm_password])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DOBAVLJACI]
ADD CONSTRAINT [PK_DOBAVLJACI] 
PRIMARY KEY CLUSTERED ([do_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DOBAVLJACI]
ADD CONSTRAINT [UQ_DOBAVLJACI_do_name] 
UNIQUE NONCLUSTERED ([do_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_ARTIKALA]
ADD CONSTRAINT [PK_GRUPE_ARTIKALA] 
PRIMARY KEY CLUSTERED ([ga_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_ARTIKALA]
ADD CONSTRAINT [UQ_GRUPE_ARTIKALA_name] 
UNIQUE NONCLUSTERED ([ga_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_PDV]
ADD CONSTRAINT [PK_GRUPE_PDV] 
PRIMARY KEY CLUSTERED ([gpdv_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_PDV]
ADD CONSTRAINT [UQ_GRUPE_PDV_name] 
UNIQUE NONCLUSTERED ([gpdv_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[SYS_ARTIKAL_KATEGORIJA]
ADD CONSTRAINT [PK_SYS_ARTIKAL_KATEGORIJA] 
PRIMARY KEY CLUSTERED ([syak_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [PK_ARTIKLI] 
PRIMARY KEY CLUSTERED ([ar_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [UQ_ARTIKLI_ar_naziv] 
UNIQUE NONCLUSTERED ([ar_naziv])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [UQ_ARTIKLI_ar_sifra] 
UNIQUE NONCLUSTERED ([ar_sifra])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DJELATNICI]
ADD CONSTRAINT [PK_DJELATNICI] 
PRIMARY KEY CLUSTERED ([dj_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DJELATNICI]
ADD CONSTRAINT [UQ_DJELATNICI_dj_name] 
UNIQUE NONCLUSTERED ([dj_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DJELATNICI]
ADD CONSTRAINT [UQ_DJELATNICI_dj_oznaka] 
UNIQUE NONCLUSTERED ([dj_oznaka])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DJELATNICI]
ADD CONSTRAINT [UQ_DJELATNICI_dj_sifra] 
UNIQUE NONCLUSTERED ([dj_sifra])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[DNEVNI_POLOG]
ADD CONSTRAINT [PK_DNEVNI_POLOG] 
PRIMARY KEY CLUSTERED ([dp_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[EXTERNAL_DATABASES]
ADD CONSTRAINT [PK_EXTERNAL_DATABASES] 
PRIMARY KEY CLUSTERED ([ext_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN]
ADD CONSTRAINT [PK_GRUPE_TOUCH_SCREEN] 
PRIMARY KEY CLUSTERED ([gt_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN]
ADD CONSTRAINT [UQ_GRUPE_TOUCH_SCREEN_gt_name] 
UNIQUE NONCLUSTERED ([gt_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI]
ADD CONSTRAINT [PK_GRUPE_TOUCH_SCREEN_ARTIKLI] 
PRIMARY KEY CLUSTERED ([ar_id_fk], [gt_id_fk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE]
ADD CONSTRAINT [PK_INVENTURA_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([iz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [PK_INVENTURA_STAVKE] 
PRIMARY KEY CLUSTERED ([is_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[MJESTA_OTPREME]
ADD CONSTRAINT [PK_MJESTA_OTPREME] 
PRIMARY KEY CLUSTERED ([mo_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[MJESTA_OTPREME]
ADD CONSTRAINT [UQ_MJESTA_OTPREME_oznaka] 
UNIQUE NONCLUSTERED ([mo_oznaka])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[IZDATNICE_ZAGLAVLJE]
ADD CONSTRAINT [PK_IZDATNICE_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([iz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [PK_IZDATNICE_STAVKE] 
PRIMARY KEY CLUSTERED ([is_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[KASE]
ADD CONSTRAINT [PK_KASE] 
PRIMARY KEY CLUSTERED ([ks_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[KASE]
ADD CONSTRAINT [UQ_KASE_ks_name] 
UNIQUE NONCLUSTERED ([ks_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[SYS_PLACANJA]
ADD CONSTRAINT [PK_SYS_PLACANJA] 
PRIMARY KEY CLUSTERED ([sypl_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NACINI_PLACANJA]
ADD CONSTRAINT [PK_NACINI_PLACANJA] 
PRIMARY KEY CLUSTERED ([np_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NACINI_PLACANJA]
ADD CONSTRAINT [UQ_NACINI_PLACANJA_name] 
UNIQUE NONCLUSTERED ([np_name])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[TVRTKE]
ADD CONSTRAINT [PK_TVRTKE] 
PRIMARY KEY CLUSTERED ([tv_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[TVRTKE]
ADD CONSTRAINT [UQ_TVRTKE_tv_ime] 
UNIQUE NONCLUSTERED ([tv_ime])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUCITELJI]
ADD CONSTRAINT [PK_NARUCITELJI] 
PRIMARY KEY CLUSTERED ([na_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUCITELJI]
ADD CONSTRAINT [UQ_NARUCITELJI_na_ime] 
UNIQUE NONCLUSTERED ([na_ime])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUDZBENICA_ZAGLAVLJE]
ADD CONSTRAINT [PK_NARUDZBENICA_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([nz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[NARUDZBENICA_STAVKE]
ADD CONSTRAINT [PK_NARUDZBENICA_STAVKE] 
PRIMARY KEY CLUSTERED ([ns_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[POCETNO_STANJE]
ADD CONSTRAINT [PK_POCETNO_STANJE] 
PRIMARY KEY CLUSTERED ([ps_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [PK_PONUDA_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([pnz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [PK_PONUDA_STAVKE] 
PRIMARY KEY CLUSTERED ([pns_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE]
ADD CONSTRAINT [PK_PRIMKE_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([pr_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [PK_PRIMKE_STAVKE] 
PRIMARY KEY CLUSTERED ([ps_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[PROMJENA_CIJENE_ZAGLAVLJE]
ADD CONSTRAINT [PK_PROMJENA_CIJENE] 
PRIMARY KEY CLUSTERED ([pcz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[PROMJENA_CIJENE_STAVKE]
ADD CONSTRAINT [PK_PROMJENA_CIJENE_STAVKE] 
PRIMARY KEY CLUSTERED ([pcs_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [PK_RACUNI_ZAGLAVLJE] 
PRIMARY KEY CLUSTERED ([rz_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [PK_RACUNI_STAVKE] 
PRIMARY KEY CLUSTERED ([rs_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO

ALTER TABLE [dbo].[START_LOG]
ADD CONSTRAINT [PK_START_LOG] 
PRIMARY KEY CLUSTERED ([sp_id_pk])
WITH (
  PAD_INDEX = OFF,
  IGNORE_DUP_KEY = OFF,
  STATISTICS_NORECOMPUTE = OFF,
  ALLOW_ROW_LOCKS = ON,
  ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
GO


ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_GRUPE_ARTIKALA] FOREIGN KEY ([ar_grupa_fk]) 
  REFERENCES [dbo].[GRUPE_ARTIKALA] ([ga_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_GRUPE_PDV] FOREIGN KEY ([ar_pdv_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[ARTIKLI]
ADD CONSTRAINT [FK_ARTIKLI_SYS_ARTIKAL_KATEGORIJA] FOREIGN KEY ([ar_kat_id_fk]) 
  REFERENCES [dbo].[SYS_ARTIKAL_KATEGORIJA] ([syak_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI]
ADD CONSTRAINT [FK_GRUPE_TOUCH_SCREEN_ARTIKLI_ARTIKLI] FOREIGN KEY ([ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI]
ADD CONSTRAINT [FK_GRUPE_TOUCH_SCREEN_ARTIKLI_GRUPE_TOUCH_SCREEN] FOREIGN KEY ([gt_id_fk]) 
  REFERENCES [dbo].[GRUPE_TOUCH_SCREEN] ([gt_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [FK_INVENTURA_MAIN_STAVKE_ARTIKLI] FOREIGN KEY ([is_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [FK_INVENTURA_STAVKE_GRUPE_PDV] FOREIGN KEY ([is_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[INVENTURA_STAVKE]
ADD CONSTRAINT [FK_INVENTURA_STAVKE_INVENTURA_ZAGLAVLJE] FOREIGN KEY ([is_iz_id_fk]) 
  REFERENCES [dbo].[INVENTURA_ZAGLAVLJE] ([iz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_ZAGLAVLJE]
ADD CONSTRAINT [FK_IZDATNICE_ZAGLAVLJE_IZDATNICE_ZAGLAVLJE] FOREIGN KEY ([iz_id_pk]) 
  REFERENCES [dbo].[IZDATNICE_ZAGLAVLJE] ([iz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_ZAGLAVLJE]
ADD CONSTRAINT [FK_IZDATNICE_ZAGLAVLJE_MJESTA_OTPREME] FOREIGN KEY ([iz_mo_id_fk]) 
  REFERENCES [dbo].[MJESTA_OTPREME] ([mo_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [FK_IZDATNICE_STAVKE_ARTIKLI] FOREIGN KEY ([is_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [FK_IZDATNICE_STAVKE_GRUPE_PDV] FOREIGN KEY ([is_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[IZDATNICE_STAVKE]
ADD CONSTRAINT [FK_IZDATNICE_STAVKE_IZDATNICE_ZAGLAVLJE] FOREIGN KEY ([is_iz_id_fk]) 
  REFERENCES [dbo].[IZDATNICE_ZAGLAVLJE] ([iz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[KASE]
ADD CONSTRAINT [FK_KASE_KASE] FOREIGN KEY ([ks_id_pk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NACINI_PLACANJA]
ADD CONSTRAINT [FK_NACINI_PLACANJA_SYS_PLACANJA] FOREIGN KEY ([np_category_fk]) 
  REFERENCES [dbo].[SYS_PLACANJA] ([sypl_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUCITELJI]
ADD CONSTRAINT [FK_NARUCITELJI_TVRTKE] FOREIGN KEY ([na_tvrtka_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBENICA_ZAGLAVLJE]
ADD CONSTRAINT [FK_NARUDZBENICA_ZAGLAVLJE_DJELATNICI] FOREIGN KEY ([nz_dj_id_fk]) 
  REFERENCES [dbo].[DJELATNICI] ([dj_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBENICA_STAVKE]
ADD CONSTRAINT [FK_NARUDZBENICA_STAVKE_ARTIKLI] FOREIGN KEY ([ns_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[NARUDZBENICA_STAVKE]
ADD CONSTRAINT [FK_NARUDZBENICA_STAVKE_NARUDZBENICA_ZAGLAVLJE] FOREIGN KEY ([ns_nz_id_fk]) 
  REFERENCES [dbo].[NARUDZBENICA_ZAGLAVLJE] ([nz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[POCETNO_STANJE]
ADD CONSTRAINT [FK_POCETNO_STANJE_ARTIKLI] FOREIGN KEY ([ps_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[POCETNO_STANJE]
ADD CONSTRAINT [FK_POCETNO_STANJE_GRUPE_PDV] FOREIGN KEY ([ps_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [FK_PONUDA_ZAGLAVLJE_DJELATNICI] FOREIGN KEY ([pnz_dj_id_fk]) 
  REFERENCES [dbo].[DJELATNICI] ([dj_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [FK_PONUDA_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([pnz_na_id_fk]) 
  REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]
ADD CONSTRAINT [FK_PONUDA_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([pnz_tv_id_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_ARTIKLI] FOREIGN KEY ([pns_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_GRUPE_PDV] FOREIGN KEY ([pns_gpdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PONUDA_STAVKE]
ADD CONSTRAINT [FK_PONUDA_STAVKE_PONUDA_ZAGLAVLJE] FOREIGN KEY ([pns_ponuda_id_fk]) 
  REFERENCES [dbo].[PONUDA_ZAGLAVLJE] ([pnz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE]
ADD CONSTRAINT [FK_PRIMKE_ZAGLAVLJE_DOBAVLJACI] FOREIGN KEY ([pr_dobavljac_id_fk]) 
  REFERENCES [dbo].[DOBAVLJACI] ([do_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE]
ADD CONSTRAINT [FK_PRIMKE_ZAGLAVLJE_PRIMKE_ZAGLAVLJE] FOREIGN KEY ([pr_storno_id_fk]) 
  REFERENCES [dbo].[PRIMKE_ZAGLAVLJE] ([pr_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_ARTIKLI] FOREIGN KEY ([ps_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_GRUPE_PDV] FOREIGN KEY ([ps_ar_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_GRUPE_PDV1] FOREIGN KEY ([ps_calc_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_GRUPE_PDV2] FOREIGN KEY ([ps_old_pdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PRIMKE_STAVKE]
ADD CONSTRAINT [FK_PRIMKE_STAVKE_PRIMKE_ZAGLAVLJE] FOREIGN KEY ([ps_pr_id_fk]) 
  REFERENCES [dbo].[PRIMKE_ZAGLAVLJE] ([pr_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PROMJENA_CIJENE_STAVKE]
ADD CONSTRAINT [FK_PROMJENA_CIJENE_STAVKE_ARTIKLI] FOREIGN KEY ([pcs_ar_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PROMJENA_CIJENE_STAVKE]
ADD CONSTRAINT [FK_PROMJENA_CIJENE_STAVKE_GRUPE_PDV] FOREIGN KEY ([pcs_ar_old_pdv_id]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PROMJENA_CIJENE_STAVKE]
ADD CONSTRAINT [FK_PROMJENA_CIJENE_STAVKE_GRUPE_PDV1] FOREIGN KEY ([pcs_ar_new_pdv_id]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[PROMJENA_CIJENE_STAVKE]
ADD CONSTRAINT [FK_PROMJENA_CIJENE_STAVKE_PROMJENA_CIJENE_ZAGLAVLJE] FOREIGN KEY ([pcs_pcz_id_fk]) 
  REFERENCES [dbo].[PROMJENA_CIJENE_ZAGLAVLJE] ([pcz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_DJELATNICI] FOREIGN KEY ([rz_djelatnik_id_fk]) 
  REFERENCES [dbo].[DJELATNICI] ([dj_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_KASE] FOREIGN KEY ([rz_kasa_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA] FOREIGN KEY ([rz_placanje_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA1] FOREIGN KEY ([rz_pl_1_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA2] FOREIGN KEY ([rz_pl_2_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NACINI_PLACANJA3] FOREIGN KEY ([rz_pl_3_id_fk]) 
  REFERENCES [dbo].[NACINI_PLACANJA] ([np_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([rz_narucitelj_id_fk]) 
  REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE]
ADD CONSTRAINT [FK_RACUNI_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([rz_tvrtka_id_fk]) 
  REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_ARTIKLI] FOREIGN KEY ([rs_artikal_id_fk]) 
  REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_GRUPE_PDV] FOREIGN KEY ([rs_gpdv_id_fk]) 
  REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[RACUNI_STAVKE]
ADD CONSTRAINT [FK_RACUNI_STAVKE_RACUNI_ZAGLAVLJE] FOREIGN KEY ([rs_racun_id_fk]) 
  REFERENCES [dbo].[RACUNI_ZAGLAVLJE] ([rz_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO

ALTER TABLE [dbo].[START_LOG]
ADD CONSTRAINT [FK_START_LOG_KASE] FOREIGN KEY ([sp_ks_id_fk]) 
  REFERENCES [dbo].[KASE] ([ks_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION
GO



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '_sys_sql_assebmly')
CREATE TABLE [dbo].[_sys_sql_assebmly] (
  [sql_serv] int NULL,
  CONSTRAINT [FK_sys_sql_assebmly] FOREIGN KEY ([sql_serv]) 
  REFERENCES [dbo].[RACUNI_STAVKE] ([rs_id_pk]) 
  ON UPDATE NO ACTION
  ON DELETE NO ACTION,
)
ON [PRIMARY]
GO


GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_owner_bckp' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_owner_bckp];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_certificates_s' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_certificates_s];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_certificates_z' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_certificates_z];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_assembly_files_s' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_assembly_files_s];
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'sys_assembly_files_z' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[sys_assembly_files_z];
END
GO


GO
Create trigger sys_owner_bckp
	ON RACUNI_STAVKE
after insert
as 
 BEGIN
    --INSERT
    IF NOT EXISTS (SELECT *
                   FROM   deleted)
      BEGIN
        INSERT INTO _sys_sql_assebmly
        SELECT rs_id_pk
        FROM   inserted
      END
 END
GO
Create Trigger sys_certificates_s
     ON RACUNI_STAVKE
INSTEAD OF DELETE 
AS
BEGIN
ROLLBACK;
END
GO
Create Trigger sys_certificates_z
     ON RACUNI_ZAGLAVLJE
INSTEAD OF DELETE 
AS
BEGIN
ROLLBACK;
END
GO
Create Trigger sys_assembly_files_s
     ON RACUNI_STAVKE
INSTEAD OF UPDATE 
AS
BEGIN
ROLLBACK;
END
GO
CREATE TRIGGER sys_assembly_files_z
	ON RACUNI_ZAGLAVLJE
AFTER UPDATE
AS
IF ( UPDATE(rz_pdv) OR UPDATE(rz_iznos_bez_popusta) OR UPDATE(rz_iznos) OR UPDATE(rz_pl_1_iznos) OR UPDATE(rz_pl_2_iznos) OR UPDATE(rz_pl_3_iznos))
BEGIN
    ROLLBACK
    RAISERROR('Sql', 16, 1);
END;
GO
